/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class LocalNetworkGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LocalNetworkGatewayInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.localNetworkAddressSpace")
    private AddressSpace localNetworkAddressSpace;
    @JsonProperty(value="properties.gatewayIpAddress")
    private String gatewayIpAddress;
    @JsonProperty(value="properties.fqdn")
    private String fqdn;
    @JsonProperty(value="properties.bgpSettings")
    private BgpSettings bgpSettings;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public AddressSpace localNetworkAddressSpace() {
        return this.localNetworkAddressSpace;
    }

    public LocalNetworkGatewayInner withLocalNetworkAddressSpace(AddressSpace localNetworkAddressSpace) {
        this.localNetworkAddressSpace = localNetworkAddressSpace;
        return this;
    }

    public String gatewayIpAddress() {
        return this.gatewayIpAddress;
    }

    public LocalNetworkGatewayInner withGatewayIpAddress(String gatewayIpAddress) {
        this.gatewayIpAddress = gatewayIpAddress;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public LocalNetworkGatewayInner withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public LocalNetworkGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public LocalNetworkGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.localNetworkAddressSpace() != null) {
            this.localNetworkAddressSpace().validate();
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
    }
}

