/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.P2SConnectionConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnClientConnectionHealth;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class P2SVpnGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(P2SVpnGatewayInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="properties.p2SConnectionConfigurations")
    private List<P2SConnectionConfiguration> p2SConnectionConfigurations;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.vpnGatewayScaleUnit")
    private Integer vpnGatewayScaleUnit;
    @JsonProperty(value="properties.vpnServerConfiguration")
    private SubResource vpnServerConfiguration;
    @JsonProperty(value="properties.vpnClientConnectionHealth", access=JsonProperty.Access.WRITE_ONLY)
    private VpnClientConnectionHealth vpnClientConnectionHealth;
    @JsonProperty(value="properties.customDnsServers")
    private List<String> customDnsServers;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public P2SVpnGatewayInner withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<P2SConnectionConfiguration> p2SConnectionConfigurations() {
        return this.p2SConnectionConfigurations;
    }

    public P2SVpnGatewayInner withP2SConnectionConfigurations(List<P2SConnectionConfiguration> p2SConnectionConfigurations) {
        this.p2SConnectionConfigurations = p2SConnectionConfigurations;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public P2SVpnGatewayInner withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public SubResource vpnServerConfiguration() {
        return this.vpnServerConfiguration;
    }

    public P2SVpnGatewayInner withVpnServerConfiguration(SubResource vpnServerConfiguration) {
        this.vpnServerConfiguration = vpnServerConfiguration;
        return this;
    }

    public VpnClientConnectionHealth vpnClientConnectionHealth() {
        return this.vpnClientConnectionHealth;
    }

    public List<String> customDnsServers() {
        return this.customDnsServers;
    }

    public P2SVpnGatewayInner withCustomDnsServers(List<String> customDnsServers) {
        this.customDnsServers = customDnsServers;
        return this;
    }

    public String id() {
        return this.id;
    }

    public P2SVpnGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.p2SConnectionConfigurations() != null) {
            this.p2SConnectionConfigurations().forEach(e -> e.validate());
        }
        if (this.vpnClientConnectionHealth() != null) {
            this.vpnClientConnectionHealth().validate();
        }
    }
}

