/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VpnConnectionInner;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VpnGatewayInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnGatewayInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.virtualHub")
    private SubResource virtualHub;
    @JsonProperty(value="properties.connections")
    private List<VpnConnectionInner> connections;
    @JsonProperty(value="properties.bgpSettings")
    private BgpSettings bgpSettings;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.vpnGatewayScaleUnit")
    private Integer vpnGatewayScaleUnit;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public SubResource virtualHub() {
        return this.virtualHub;
    }

    public VpnGatewayInner withVirtualHub(SubResource virtualHub) {
        this.virtualHub = virtualHub;
        return this;
    }

    public List<VpnConnectionInner> connections() {
        return this.connections;
    }

    public VpnGatewayInner withConnections(List<VpnConnectionInner> connections) {
        this.connections = connections;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public VpnGatewayInner withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer vpnGatewayScaleUnit() {
        return this.vpnGatewayScaleUnit;
    }

    public VpnGatewayInner withVpnGatewayScaleUnit(Integer vpnGatewayScaleUnit) {
        this.vpnGatewayScaleUnit = vpnGatewayScaleUnit;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VpnGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.connections() != null) {
            this.connections().forEach(e -> e.validate());
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
    }
}

