/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.DeviceProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VpnSiteInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VpnSiteInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.virtualWan")
    private SubResource virtualWan;
    @JsonProperty(value="properties.deviceProperties")
    private DeviceProperties deviceProperties;
    @JsonProperty(value="properties.ipAddress")
    private String ipAddress;
    @JsonProperty(value="properties.siteKey")
    private String siteKey;
    @JsonProperty(value="properties.addressSpace")
    private AddressSpace addressSpace;
    @JsonProperty(value="properties.bgpProperties")
    private BgpSettings bgpProperties;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.isSecuritySite")
    private Boolean isSecuritySite;
    @JsonProperty(value="properties.vpnSiteLinks")
    private List<VpnSiteLinkInner> vpnSiteLinks;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public SubResource virtualWan() {
        return this.virtualWan;
    }

    public VpnSiteInner withVirtualWan(SubResource virtualWan) {
        this.virtualWan = virtualWan;
        return this;
    }

    public DeviceProperties deviceProperties() {
        return this.deviceProperties;
    }

    public VpnSiteInner withDeviceProperties(DeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public VpnSiteInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String siteKey() {
        return this.siteKey;
    }

    public VpnSiteInner withSiteKey(String siteKey) {
        this.siteKey = siteKey;
        return this;
    }

    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    public VpnSiteInner withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    public BgpSettings bgpProperties() {
        return this.bgpProperties;
    }

    public VpnSiteInner withBgpProperties(BgpSettings bgpProperties) {
        this.bgpProperties = bgpProperties;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean isSecuritySite() {
        return this.isSecuritySite;
    }

    public VpnSiteInner withIsSecuritySite(Boolean isSecuritySite) {
        this.isSecuritySite = isSecuritySite;
        return this;
    }

    public List<VpnSiteLinkInner> vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    public VpnSiteInner withVpnSiteLinks(List<VpnSiteLinkInner> vpnSiteLinks) {
        this.vpnSiteLinks = vpnSiteLinks;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VpnSiteInner withId(String id) {
        this.id = id;
        return this;
    }

    public void validate() {
        if (this.deviceProperties() != null) {
            this.deviceProperties().validate();
        }
        if (this.addressSpace() != null) {
            this.addressSpace().validate();
        }
        if (this.bgpProperties() != null) {
            this.bgpProperties().validate();
        }
        if (this.vpnSiteLinks() != null) {
            this.vpnSiteLinks().forEach(e -> e.validate());
        }
    }
}

