/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.ExpressRouteCrossConnectionsClient;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionInner;
import com.azure.resourcemanager.network.implementation.ExpressRouteCrossConnectionImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnection;
import com.azure.resourcemanager.network.models.ExpressRouteCrossConnections;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import reactor.core.publisher.Mono;

public class ExpressRouteCrossConnectionsImpl
extends ReadableWrappersImpl<ExpressRouteCrossConnection, ExpressRouteCrossConnectionImpl, ExpressRouteCrossConnectionInner>
implements ExpressRouteCrossConnections {
    private final NetworkManager manager;

    public ExpressRouteCrossConnectionsImpl(NetworkManager manager) {
        this.manager = manager;
    }

    protected ExpressRouteCrossConnectionImpl wrapModel(ExpressRouteCrossConnectionInner inner) {
        if (inner == null) {
            return null;
        }
        return new ExpressRouteCrossConnectionImpl(inner.name(), inner, this.manager());
    }

    public ExpressRouteCrossConnection getById(String id) {
        return (ExpressRouteCrossConnection)this.getByIdAsync(id).block();
    }

    public Mono<ExpressRouteCrossConnection> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByResourceGroupAsync(resourceId.resourceGroupName(), resourceId.name());
    }

    public ExpressRouteCrossConnection getByResourceGroup(String resourceGroupName, String name) {
        return (ExpressRouteCrossConnection)this.getByResourceGroupAsync(resourceGroupName, name).block();
    }

    public Mono<ExpressRouteCrossConnection> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.inner().getByResourceGroupAsync(resourceGroupName, name).map(inner -> this.wrapModel((ExpressRouteCrossConnectionInner)((Object)inner)));
    }

    public PagedIterable<ExpressRouteCrossConnection> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(this.inner().listByResourceGroup(resourceGroupName));
    }

    public PagedFlux<ExpressRouteCrossConnection> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(this.inner().listByResourceGroupAsync(resourceGroupName));
    }

    public NetworkManager manager() {
        return this.manager;
    }

    public PagedIterable<ExpressRouteCrossConnection> list() {
        return this.wrapList(this.inner().list());
    }

    public PagedFlux<ExpressRouteCrossConnection> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    public ExpressRouteCrossConnectionsClient inner() {
        return ((NetworkManagementClient)this.manager.serviceClient()).getExpressRouteCrossConnections();
    }
}

