/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.FlowLogInformationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkWatcherInner;
import com.azure.resourcemanager.network.fluent.models.SecurityGroupViewResultInner;
import com.azure.resourcemanager.network.implementation.AvailableProvidersImpl;
import com.azure.resourcemanager.network.implementation.AzureReachabilityReportImpl;
import com.azure.resourcemanager.network.implementation.ConnectionMonitorsImpl;
import com.azure.resourcemanager.network.implementation.ConnectivityCheckImpl;
import com.azure.resourcemanager.network.implementation.FlowLogSettingsImpl;
import com.azure.resourcemanager.network.implementation.NextHopImpl;
import com.azure.resourcemanager.network.implementation.PacketCapturesImpl;
import com.azure.resourcemanager.network.implementation.SecurityGroupViewImpl;
import com.azure.resourcemanager.network.implementation.TopologyImpl;
import com.azure.resourcemanager.network.implementation.TroubleshootingImpl;
import com.azure.resourcemanager.network.implementation.VerificationIPFlowImpl;
import com.azure.resourcemanager.network.models.AppliableWithTags;
import com.azure.resourcemanager.network.models.FlowLogSettings;
import com.azure.resourcemanager.network.models.NetworkWatcher;
import com.azure.resourcemanager.network.models.SecurityGroupView;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import reactor.core.publisher.Mono;

class NetworkWatcherImpl
extends GroupableResourceImpl<NetworkWatcher, NetworkWatcherInner, NetworkWatcherImpl, NetworkManager>
implements NetworkWatcher,
NetworkWatcher.Definition,
NetworkWatcher.Update,
AppliableWithTags<NetworkWatcher> {
    private PacketCapturesImpl packetCaptures;
    private ConnectionMonitorsImpl connectionMonitors;

    NetworkWatcherImpl(String name, NetworkWatcherInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (Manager)networkManager);
        this.packetCaptures = new PacketCapturesImpl(((NetworkManagementClient)networkManager.serviceClient()).getPacketCaptures(), this);
        this.connectionMonitors = new ConnectionMonitorsImpl(((NetworkManagementClient)networkManager.serviceClient()).getConnectionMonitors(), this);
    }

    @Override
    public PacketCapturesImpl packetCaptures() {
        return this.packetCaptures;
    }

    @Override
    public ConnectionMonitorsImpl connectionMonitors() {
        return this.connectionMonitors;
    }

    @Override
    public TopologyImpl topology() {
        return new TopologyImpl(this);
    }

    @Override
    public SecurityGroupView getSecurityGroupView(String vmId) {
        SecurityGroupViewResultInner securityGroupViewResultInner = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().getVMSecurityRules(this.resourceGroupName(), this.name(), vmId);
        return new SecurityGroupViewImpl(this, securityGroupViewResultInner, vmId);
    }

    @Override
    public Mono<SecurityGroupView> getSecurityGroupViewAsync(String vmId) {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().getVMSecurityRulesAsync(this.resourceGroupName(), this.name(), vmId).map(inner -> new SecurityGroupViewImpl(this, (SecurityGroupViewResultInner)inner, vmId));
    }

    @Override
    public FlowLogSettings getFlowLogSettings(String nsgId) {
        FlowLogInformationInner flowLogInformationInner = ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().getFlowLogStatus(this.resourceGroupName(), this.name(), nsgId);
        return new FlowLogSettingsImpl(this, flowLogInformationInner, nsgId);
    }

    @Override
    public Mono<FlowLogSettings> getFlowLogSettingsAsync(String nsgId) {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().getFlowLogStatusAsync(this.resourceGroupName(), this.name(), nsgId).map(inner -> new FlowLogSettingsImpl(this, (FlowLogInformationInner)inner, nsgId));
    }

    @Override
    public NextHopImpl nextHop() {
        return new NextHopImpl(this);
    }

    @Override
    public VerificationIPFlowImpl verifyIPFlow() {
        return new VerificationIPFlowImpl(this);
    }

    @Override
    public ConnectivityCheckImpl checkConnectivity() {
        return new ConnectivityCheckImpl(this);
    }

    @Override
    public TroubleshootingImpl troubleshoot() {
        return new TroubleshootingImpl(this);
    }

    @Override
    public AvailableProvidersImpl availableProviders() {
        return new AvailableProvidersImpl(this);
    }

    @Override
    public AzureReachabilityReportImpl azureReachabilityReport() {
        return new AzureReachabilityReportImpl(this);
    }

    public Mono<NetworkWatcher> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkWatcherInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<NetworkWatcherInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public NetworkWatcherImpl updateTags() {
        return this;
    }

    @Override
    public NetworkWatcher applyTags() {
        return (NetworkWatcher)this.applyTagsAsync().block();
    }

    @Override
    public Mono<NetworkWatcher> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkWatchers().updateTagsAsync(this.resourceGroupName(), this.name(), ((NetworkWatcherInner)((Object)this.innerModel())).tags()).flatMap(inner -> {
            this.setInner(inner);
            return Mono.just((Object)this);
        });
    }
}

