/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.PrivateEndpointsClient;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ErrorException;
import com.azure.resourcemanager.network.models.PrivateEndpointListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PrivateEndpointsClientImpl
implements InnerSupportsGet<PrivateEndpointInner>,
InnerSupportsListing<PrivateEndpointInner>,
InnerSupportsDelete<Void>,
PrivateEndpointsClient {
    private final ClientLogger logger = new ClientLogger(PrivateEndpointsClientImpl.class);
    private final PrivateEndpointsService service;
    private final NetworkManagementClientImpl client;

    PrivateEndpointsClientImpl(NetworkManagementClientImpl client) {
        this.service = (PrivateEndpointsService)RestProxy.create(PrivateEndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String privateEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, privateEndpointName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String privateEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, privateEndpointName, "2020-05-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String privateEndpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, privateEndpointName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String privateEndpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, privateEndpointName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String privateEndpointName) {
        return this.beginDeleteAsync(resourceGroupName, privateEndpointName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String privateEndpointName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, privateEndpointName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String privateEndpointName) {
        return this.beginDeleteAsync(resourceGroupName, privateEndpointName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String privateEndpointName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, privateEndpointName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String privateEndpointName) {
        this.deleteAsync(resourceGroupName, privateEndpointName).block();
    }

    @Override
    public void delete(String resourceGroupName, String privateEndpointName, Context context) {
        this.deleteAsync(resourceGroupName, privateEndpointName, context).block();
    }

    @Override
    public Mono<Response<PrivateEndpointInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String privateEndpointName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, privateEndpointName, "2020-05-01", this.client.getSubscriptionId(), expand, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<PrivateEndpointInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String privateEndpointName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, privateEndpointName, "2020-05-01", this.client.getSubscriptionId(), expand, context);
    }

    @Override
    public Mono<PrivateEndpointInner> getByResourceGroupAsync(String resourceGroupName, String privateEndpointName, String expand) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, privateEndpointName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PrivateEndpointInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<PrivateEndpointInner> getByResourceGroupAsync(String resourceGroupName, String privateEndpointName) {
        String expand = null;
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, privateEndpointName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PrivateEndpointInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public PrivateEndpointInner getByResourceGroup(String resourceGroupName, String privateEndpointName) {
        String expand = null;
        return (PrivateEndpointInner)((Object)this.getByResourceGroupAsync(resourceGroupName, privateEndpointName, expand).block());
    }

    @Override
    public Response<PrivateEndpointInner> getByResourceGroupWithResponse(String resourceGroupName, String privateEndpointName, String expand, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, privateEndpointName, expand, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, privateEndpointName, "2020-05-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, privateEndpointName, "2020-05-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<PrivateEndpointInner>, PrivateEndpointInner> beginCreateOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, privateEndpointName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointInner.class), (Type)((Object)PrivateEndpointInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<PrivateEndpointInner>, PrivateEndpointInner> beginCreateOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, privateEndpointName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)PrivateEndpointInner.class), (Type)((Object)PrivateEndpointInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<PrivateEndpointInner>, PrivateEndpointInner> beginCreateOrUpdate(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateEndpointName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<PrivateEndpointInner>, PrivateEndpointInner> beginCreateOrUpdate(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateEndpointName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<PrivateEndpointInner> createOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateEndpointName, parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<PrivateEndpointInner> createOrUpdateAsync(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateEndpointName, parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public PrivateEndpointInner createOrUpdate(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters) {
        return (PrivateEndpointInner)((Object)this.createOrUpdateAsync(resourceGroupName, privateEndpointName, parameters).block());
    }

    @Override
    public PrivateEndpointInner createOrUpdate(String resourceGroupName, String privateEndpointName, PrivateEndpointInner parameters, Context context) {
        return (PrivateEndpointInner)((Object)this.createOrUpdateAsync(resourceGroupName, privateEndpointName, parameters, context).block());
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2020-05-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2020-05-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PrivateEndpointInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PrivateEndpointInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PrivateEndpointInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedIterable<PrivateEndpointInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-05-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-05-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2020-05-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<PrivateEndpointInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<PrivateEndpointInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<PrivateEndpointInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    public PagedIterable<PrivateEndpointInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PrivateEndpointInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointListResult)res.getValue()).value(), ((PrivateEndpointListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface PrivateEndpointsService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateEndpointName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<PrivateEndpointInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateEndpointName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="$expand") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateEndpointName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") PrivateEndpointInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<PrivateEndpointListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/privateEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<PrivateEndpointListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<PrivateEndpointListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<PrivateEndpointListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

