/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AzureFirewallNatRCAction;
import com.azure.resourcemanager.network.models.AzureFirewallNatRule;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class AzureFirewallNatRuleCollection
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFirewallNatRuleCollection.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.priority")
    private Integer priority;
    @JsonProperty(value="properties.action")
    private AzureFirewallNatRCAction action;
    @JsonProperty(value="properties.rules")
    private List<AzureFirewallNatRule> rules;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public AzureFirewallNatRuleCollection withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public Integer priority() {
        return this.priority;
    }

    public AzureFirewallNatRuleCollection withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public AzureFirewallNatRCAction action() {
        return this.action;
    }

    public AzureFirewallNatRuleCollection withAction(AzureFirewallNatRCAction action) {
        this.action = action;
        return this;
    }

    public List<AzureFirewallNatRule> rules() {
        return this.rules;
    }

    public AzureFirewallNatRuleCollection withRules(List<AzureFirewallNatRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }
}

