/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AzureFirewallNetworkRule;
import com.azure.resourcemanager.network.models.AzureFirewallRCAction;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class AzureFirewallNetworkRuleCollection
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureFirewallNetworkRuleCollection.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.priority")
    private Integer priority;
    @JsonProperty(value="properties.action")
    private AzureFirewallRCAction action;
    @JsonProperty(value="properties.rules")
    private List<AzureFirewallNetworkRule> rules;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public AzureFirewallNetworkRuleCollection withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public Integer priority() {
        return this.priority;
    }

    public AzureFirewallNetworkRuleCollection withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public AzureFirewallRCAction action() {
        return this.action;
    }

    public AzureFirewallNetworkRuleCollection withAction(AzureFirewallRCAction action) {
        this.action = action;
        return this;
    }

    public List<AzureFirewallNetworkRule> rules() {
        return this.rules;
    }

    public AzureFirewallNetworkRuleCollection withRules(List<AzureFirewallNetworkRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }
}

