/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceIpConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ContainerNetworkInterface
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerNetworkInterface.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.containerNetworkInterfaceConfiguration", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration;
    @JsonProperty(value="properties.container")
    private SubResource container;
    @JsonProperty(value="properties.ipConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public ContainerNetworkInterface withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration() {
        return this.containerNetworkInterfaceConfiguration;
    }

    public SubResource container() {
        return this.container;
    }

    public ContainerNetworkInterface withContainer(SubResource container) {
        this.container = container;
        return this;
    }

    public List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.containerNetworkInterfaceConfiguration() != null) {
            this.containerNetworkInterfaceConfiguration().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }
}

