/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.fluent.models.RouteFilterRuleInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RouteFilterPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteFilterPropertiesFormat.class);
    @JsonProperty(value="rules")
    private List<RouteFilterRuleInner> rules;
    @JsonProperty(value="peerings", access=JsonProperty.Access.WRITE_ONLY)
    private List<ExpressRouteCircuitPeeringInner> peerings;
    @JsonProperty(value="ipv6Peerings", access=JsonProperty.Access.WRITE_ONLY)
    private List<ExpressRouteCircuitPeeringInner> ipv6Peerings;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public List<RouteFilterRuleInner> rules() {
        return this.rules;
    }

    public RouteFilterPropertiesFormat withRules(List<RouteFilterRuleInner> rules) {
        this.rules = rules;
        return this;
    }

    public List<ExpressRouteCircuitPeeringInner> peerings() {
        return this.peerings;
    }

    public List<ExpressRouteCircuitPeeringInner> ipv6Peerings() {
        return this.ipv6Peerings;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.peerings() != null) {
            this.peerings().forEach(e -> e.validate());
        }
        if (this.ipv6Peerings() != null) {
            this.ipv6Peerings().forEach(e -> e.validate());
        }
    }
}

