/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.azure.resourcemanager.network.models.VirtualNetworkEncryption;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringLevel;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class VirtualNetworkPeeringPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkPeeringPropertiesFormat.class);
    @JsonProperty(value="allowVirtualNetworkAccess")
    private Boolean allowVirtualNetworkAccess;
    @JsonProperty(value="allowForwardedTraffic")
    private Boolean allowForwardedTraffic;
    @JsonProperty(value="allowGatewayTransit")
    private Boolean allowGatewayTransit;
    @JsonProperty(value="useRemoteGateways")
    private Boolean useRemoteGateways;
    @JsonProperty(value="remoteVirtualNetwork")
    private SubResource remoteVirtualNetwork;
    @JsonProperty(value="remoteAddressSpace")
    private AddressSpace remoteAddressSpace;
    @JsonProperty(value="remoteVirtualNetworkAddressSpace")
    private AddressSpace remoteVirtualNetworkAddressSpace;
    @JsonProperty(value="remoteBgpCommunities")
    private VirtualNetworkBgpCommunities remoteBgpCommunities;
    @JsonProperty(value="remoteVirtualNetworkEncryption", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualNetworkEncryption remoteVirtualNetworkEncryption;
    @JsonProperty(value="peeringState")
    private VirtualNetworkPeeringState peeringState;
    @JsonProperty(value="peeringSyncLevel")
    private VirtualNetworkPeeringLevel peeringSyncLevel;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="doNotVerifyRemoteGateways")
    private Boolean doNotVerifyRemoteGateways;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    public Boolean allowVirtualNetworkAccess() {
        return this.allowVirtualNetworkAccess;
    }

    public VirtualNetworkPeeringPropertiesFormat withAllowVirtualNetworkAccess(Boolean allowVirtualNetworkAccess) {
        this.allowVirtualNetworkAccess = allowVirtualNetworkAccess;
        return this;
    }

    public Boolean allowForwardedTraffic() {
        return this.allowForwardedTraffic;
    }

    public VirtualNetworkPeeringPropertiesFormat withAllowForwardedTraffic(Boolean allowForwardedTraffic) {
        this.allowForwardedTraffic = allowForwardedTraffic;
        return this;
    }

    public Boolean allowGatewayTransit() {
        return this.allowGatewayTransit;
    }

    public VirtualNetworkPeeringPropertiesFormat withAllowGatewayTransit(Boolean allowGatewayTransit) {
        this.allowGatewayTransit = allowGatewayTransit;
        return this;
    }

    public Boolean useRemoteGateways() {
        return this.useRemoteGateways;
    }

    public VirtualNetworkPeeringPropertiesFormat withUseRemoteGateways(Boolean useRemoteGateways) {
        this.useRemoteGateways = useRemoteGateways;
        return this;
    }

    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    public AddressSpace remoteAddressSpace() {
        return this.remoteAddressSpace;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteAddressSpace(AddressSpace remoteAddressSpace) {
        this.remoteAddressSpace = remoteAddressSpace;
        return this;
    }

    public AddressSpace remoteVirtualNetworkAddressSpace() {
        return this.remoteVirtualNetworkAddressSpace;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteVirtualNetworkAddressSpace(AddressSpace remoteVirtualNetworkAddressSpace) {
        this.remoteVirtualNetworkAddressSpace = remoteVirtualNetworkAddressSpace;
        return this;
    }

    public VirtualNetworkBgpCommunities remoteBgpCommunities() {
        return this.remoteBgpCommunities;
    }

    public VirtualNetworkPeeringPropertiesFormat withRemoteBgpCommunities(VirtualNetworkBgpCommunities remoteBgpCommunities) {
        this.remoteBgpCommunities = remoteBgpCommunities;
        return this;
    }

    public VirtualNetworkEncryption remoteVirtualNetworkEncryption() {
        return this.remoteVirtualNetworkEncryption;
    }

    public VirtualNetworkPeeringState peeringState() {
        return this.peeringState;
    }

    public VirtualNetworkPeeringPropertiesFormat withPeeringState(VirtualNetworkPeeringState peeringState) {
        this.peeringState = peeringState;
        return this;
    }

    public VirtualNetworkPeeringLevel peeringSyncLevel() {
        return this.peeringSyncLevel;
    }

    public VirtualNetworkPeeringPropertiesFormat withPeeringSyncLevel(VirtualNetworkPeeringLevel peeringSyncLevel) {
        this.peeringSyncLevel = peeringSyncLevel;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean doNotVerifyRemoteGateways() {
        return this.doNotVerifyRemoteGateways;
    }

    public VirtualNetworkPeeringPropertiesFormat withDoNotVerifyRemoteGateways(Boolean doNotVerifyRemoteGateways) {
        this.doNotVerifyRemoteGateways = doNotVerifyRemoteGateways;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.remoteAddressSpace() != null) {
            this.remoteAddressSpace().validate();
        }
        if (this.remoteVirtualNetworkAddressSpace() != null) {
            this.remoteVirtualNetworkAddressSpace().validate();
        }
        if (this.remoteBgpCommunities() != null) {
            this.remoteBgpCommunities().validate();
        }
        if (this.remoteVirtualNetworkEncryption() != null) {
            this.remoteVirtualNetworkEncryption().validate();
        }
    }
}

