/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.TroubleshootingProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class TroubleshootingParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TroubleshootingParameters.class);
    @JsonProperty(value="targetResourceId", required=true)
    private String targetResourceId;
    @JsonProperty(value="properties", required=true)
    private TroubleshootingProperties innerProperties = new TroubleshootingProperties();

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public TroubleshootingParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    private TroubleshootingProperties innerProperties() {
        return this.innerProperties;
    }

    public String storageId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageId();
    }

    public TroubleshootingParameters withStorageId(String storageId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TroubleshootingProperties();
        }
        this.innerProperties().withStorageId(storageId);
        return this;
    }

    public String storagePath() {
        return this.innerProperties() == null ? null : this.innerProperties().storagePath();
    }

    public TroubleshootingParameters withStoragePath(String storagePath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TroubleshootingProperties();
        }
        this.innerProperties().withStoragePath(storagePath);
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model TroubleshootingParameters"));
        }
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model TroubleshootingParameters"));
        }
        this.innerProperties().validate();
    }
}

