/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.FlowLogInner;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkSecurityGroupPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(NetworkSecurityGroupPropertiesFormat.class);
    @JsonProperty(value="securityRules")
    private List<SecurityRuleInner> securityRules;
    @JsonProperty(value="defaultSecurityRules", access=JsonProperty.Access.WRITE_ONLY)
    private List<SecurityRuleInner> defaultSecurityRules;
    @JsonProperty(value="networkInterfaces", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> networkInterfaces;
    @JsonProperty(value="subnets", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubnetInner> subnets;
    @JsonProperty(value="flowLogs", access=JsonProperty.Access.WRITE_ONLY)
    private List<FlowLogInner> flowLogs;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public List<SecurityRuleInner> securityRules() {
        return this.securityRules;
    }

    public NetworkSecurityGroupPropertiesFormat withSecurityRules(List<SecurityRuleInner> securityRules) {
        this.securityRules = securityRules;
        return this;
    }

    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public List<FlowLogInner> flowLogs() {
        return this.flowLogs;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.securityRules() != null) {
            this.securityRules().forEach(e -> e.validate());
        }
        if (this.defaultSecurityRules() != null) {
            this.defaultSecurityRules().forEach(e -> e.validate());
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.flowLogs() != null) {
            this.flowLogs().forEach(e -> e.validate());
        }
    }
}

