/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class PacketCaptureParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PacketCaptureParameters.class);
    @JsonProperty(value="target", required=true)
    private String target;
    @JsonProperty(value="bytesToCapturePerPacket")
    private Long bytesToCapturePerPacket;
    @JsonProperty(value="totalBytesPerSession")
    private Long totalBytesPerSession;
    @JsonProperty(value="timeLimitInSeconds")
    private Integer timeLimitInSeconds;
    @JsonProperty(value="storageLocation", required=true)
    private PacketCaptureStorageLocation storageLocation;
    @JsonProperty(value="filters")
    private List<PacketCaptureFilter> filters;

    public String target() {
        return this.target;
    }

    public PacketCaptureParameters withTarget(String target) {
        this.target = target;
        return this;
    }

    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    public PacketCaptureParameters withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    public PacketCaptureParameters withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    public PacketCaptureParameters withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public PacketCaptureParameters withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    public PacketCaptureParameters withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.target() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property target in model PacketCaptureParameters"));
        }
        if (this.storageLocation() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageLocation in model PacketCaptureParameters"));
        }
        this.storageLocation().validate();
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
    }
}

