/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnNatRuleMapping;
import com.azure.resourcemanager.network.models.VpnNatRuleMode;
import com.azure.resourcemanager.network.models.VpnNatRuleType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualNetworkGatewayNatRuleProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkGatewayNatRuleProperties.class);
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="type")
    private VpnNatRuleType type;
    @JsonProperty(value="mode")
    private VpnNatRuleMode mode;
    @JsonProperty(value="internalMappings")
    private List<VpnNatRuleMapping> internalMappings;
    @JsonProperty(value="externalMappings")
    private List<VpnNatRuleMapping> externalMappings;
    @JsonProperty(value="ipConfigurationId")
    private String ipConfigurationId;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public VpnNatRuleType type() {
        return this.type;
    }

    public VirtualNetworkGatewayNatRuleProperties withType(VpnNatRuleType type) {
        this.type = type;
        return this;
    }

    public VpnNatRuleMode mode() {
        return this.mode;
    }

    public VirtualNetworkGatewayNatRuleProperties withMode(VpnNatRuleMode mode) {
        this.mode = mode;
        return this;
    }

    public List<VpnNatRuleMapping> internalMappings() {
        return this.internalMappings;
    }

    public VirtualNetworkGatewayNatRuleProperties withInternalMappings(List<VpnNatRuleMapping> internalMappings) {
        this.internalMappings = internalMappings;
        return this;
    }

    public List<VpnNatRuleMapping> externalMappings() {
        return this.externalMappings;
    }

    public VirtualNetworkGatewayNatRuleProperties withExternalMappings(List<VpnNatRuleMapping> externalMappings) {
        this.externalMappings = externalMappings;
        return this;
    }

    public String ipConfigurationId() {
        return this.ipConfigurationId;
    }

    public VirtualNetworkGatewayNatRuleProperties withIpConfigurationId(String ipConfigurationId) {
        this.ipConfigurationId = ipConfigurationId;
        return this;
    }

    public void validate() {
        if (this.internalMappings() != null) {
            this.internalMappings().forEach(e -> e.validate());
        }
        if (this.externalMappings() != null) {
            this.externalMappings().forEach(e -> e.validate());
        }
    }
}

