/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AzureReachabilityReportLocation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class AzureReachabilityReportParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureReachabilityReportParameters.class);
    @JsonProperty(value="providerLocation", required=true)
    private AzureReachabilityReportLocation providerLocation;
    @JsonProperty(value="providers")
    private List<String> providers;
    @JsonProperty(value="azureLocations")
    private List<String> azureLocations;
    @JsonProperty(value="startTime", required=true)
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime", required=true)
    private OffsetDateTime endTime;

    public AzureReachabilityReportLocation providerLocation() {
        return this.providerLocation;
    }

    public AzureReachabilityReportParameters withProviderLocation(AzureReachabilityReportLocation providerLocation) {
        this.providerLocation = providerLocation;
        return this;
    }

    public List<String> providers() {
        return this.providers;
    }

    public AzureReachabilityReportParameters withProviders(List<String> providers) {
        this.providers = providers;
        return this;
    }

    public List<String> azureLocations() {
        return this.azureLocations;
    }

    public AzureReachabilityReportParameters withAzureLocations(List<String> azureLocations) {
        this.azureLocations = azureLocations;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AzureReachabilityReportParameters withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public AzureReachabilityReportParameters withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public void validate() {
        if (this.providerLocation() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property providerLocation in model AzureReachabilityReportParameters"));
        }
        this.providerLocation().validate();
        if (this.startTime() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property startTime in model AzureReachabilityReportParameters"));
        }
        if (this.endTime() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property endTime in model AzureReachabilityReportParameters"));
        }
    }
}

