/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpointFilter;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpointScope;
import com.azure.resourcemanager.network.models.CoverageLevel;
import com.azure.resourcemanager.network.models.EndpointType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ConnectionMonitorEndpoint {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ConnectionMonitorEndpoint.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type")
    private EndpointType type;
    @JsonProperty(value="resourceId")
    private String resourceId;
    @JsonProperty(value="address")
    private String address;
    @JsonProperty(value="filter")
    private ConnectionMonitorEndpointFilter filter;
    @JsonProperty(value="scope")
    private ConnectionMonitorEndpointScope scope;
    @JsonProperty(value="coverageLevel")
    private CoverageLevel coverageLevel;

    public String name() {
        return this.name;
    }

    public ConnectionMonitorEndpoint withName(String name) {
        this.name = name;
        return this;
    }

    public EndpointType type() {
        return this.type;
    }

    public ConnectionMonitorEndpoint withType(EndpointType type) {
        this.type = type;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ConnectionMonitorEndpoint withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String address() {
        return this.address;
    }

    public ConnectionMonitorEndpoint withAddress(String address) {
        this.address = address;
        return this;
    }

    public ConnectionMonitorEndpointFilter filter() {
        return this.filter;
    }

    public ConnectionMonitorEndpoint withFilter(ConnectionMonitorEndpointFilter filter) {
        this.filter = filter;
        return this;
    }

    public ConnectionMonitorEndpointScope scope() {
        return this.scope;
    }

    public ConnectionMonitorEndpoint withScope(ConnectionMonitorEndpointScope scope) {
        this.scope = scope;
        return this;
    }

    public CoverageLevel coverageLevel() {
        return this.coverageLevel;
    }

    public ConnectionMonitorEndpoint withCoverageLevel(CoverageLevel coverageLevel) {
        this.coverageLevel = coverageLevel;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model ConnectionMonitorEndpoint"));
        }
        if (this.filter() != null) {
            this.filter().validate();
        }
        if (this.scope() != null) {
            this.scope().validate();
        }
    }
}

