/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ContainerNetworkInterfacePropertiesFormat;
import com.azure.resourcemanager.network.models.Container;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceIpConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerNetworkInterface
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerNetworkInterface.class);
    @JsonProperty(value="properties")
    private ContainerNetworkInterfacePropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;

    private ContainerNetworkInterfacePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ContainerNetworkInterface withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public ContainerNetworkInterface withId(String id) {
        super.withId(id);
        return this;
    }

    public ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaceConfiguration();
    }

    public Container container() {
        return this.innerProperties() == null ? null : this.innerProperties().container();
    }

    public ContainerNetworkInterface withContainer(Container container) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfacePropertiesFormat();
        }
        this.innerProperties().withContainer(container);
        return this;
    }

    public List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

