// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Application gateway client authentication configuration. */
@Fluent
public final class ApplicationGatewayClientAuthConfiguration {
    /*
     * Verify client certificate issuer name on the application gateway.
     */
    @JsonProperty(value = "verifyClientCertIssuerDN")
    private Boolean verifyClientCertIssuerDN;

    /**
     * Get the verifyClientCertIssuerDN property: Verify client certificate issuer name on the application gateway.
     *
     * @return the verifyClientCertIssuerDN value.
     */
    public Boolean verifyClientCertIssuerDN() {
        return this.verifyClientCertIssuerDN;
    }

    /**
     * Set the verifyClientCertIssuerDN property: Verify client certificate issuer name on the application gateway.
     *
     * @param verifyClientCertIssuerDN the verifyClientCertIssuerDN value to set.
     * @return the ApplicationGatewayClientAuthConfiguration object itself.
     */
    public ApplicationGatewayClientAuthConfiguration withVerifyClientCertIssuerDN(Boolean verifyClientCertIssuerDN) {
        this.verifyClientCertIssuerDN = verifyClientCertIssuerDN;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
