// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.DdosProtectionPlanInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A list of DDoS protection plans. */
@Fluent
public final class DdosProtectionPlanListResult {
    /*
     * A list of DDoS protection plans.
     */
    @JsonProperty(value = "value")
    private List<DdosProtectionPlanInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink", access = JsonProperty.Access.WRITE_ONLY)
    private String nextLink;

    /**
     * Get the value property: A list of DDoS protection plans.
     *
     * @return the value value.
     */
    public List<DdosProtectionPlanInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of DDoS protection plans.
     *
     * @param value the value value to set.
     * @return the DdosProtectionPlanListResult object itself.
     */
    public DdosProtectionPlanListResult withValue(List<DdosProtectionPlanInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
