// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for OrderByOrder. */
public final class OrderByOrder extends ExpandableStringEnum<OrderByOrder> {
    /** Static value Ascending for OrderByOrder. */
    public static final OrderByOrder ASCENDING = fromString("Ascending");

    /** Static value Descending for OrderByOrder. */
    public static final OrderByOrder DESCENDING = fromString("Descending");

    /**
     * Creates or finds a OrderByOrder from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OrderByOrder.
     */
    @JsonCreator
    public static OrderByOrder fromString(String name) {
        return fromString(name, OrderByOrder.class);
    }

    /** @return known OrderByOrder values. */
    public static Collection<OrderByOrder> values() {
        return values(OrderByOrder.class);
    }
}
