// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SingleQueryResultSeverity. */
public final class SingleQueryResultSeverity extends ExpandableStringEnum<SingleQueryResultSeverity> {
    /** Static value 1 for SingleQueryResultSeverity. */
    public static final SingleQueryResultSeverity ONE = fromInt(1);

    /** Static value 2 for SingleQueryResultSeverity. */
    public static final SingleQueryResultSeverity TWO = fromInt(2);

    /** Static value 3 for SingleQueryResultSeverity. */
    public static final SingleQueryResultSeverity THREE = fromInt(3);

    /**
     * Creates or finds a SingleQueryResultSeverity from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SingleQueryResultSeverity.
     */
    @JsonCreator
    public static SingleQueryResultSeverity fromInt(int name) {
        return fromString(String.valueOf(name), SingleQueryResultSeverity.class);
    }

    /** @return known SingleQueryResultSeverity values. */
    public static Collection<SingleQueryResultSeverity> values() {
        return values(SingleQueryResultSeverity.class);
    }
}
