/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolPropertiesFormat;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.azure.resourcemanager.network.models.GatewayLoadBalancerTunnelInterface;
import com.azure.resourcemanager.network.models.LoadBalancerBackendAddress;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class BackendAddressPoolInner
extends SubResource {
    @JsonProperty(value="properties")
    private BackendAddressPoolPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private BackendAddressPoolPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public BackendAddressPoolInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public BackendAddressPoolInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String location() {
        return this.innerProperties() == null ? null : this.innerProperties().location();
    }

    public BackendAddressPoolInner withLocation(String location) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withLocation(location);
        return this;
    }

    public List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().tunnelInterfaces();
    }

    public BackendAddressPoolInner withTunnelInterfaces(List<GatewayLoadBalancerTunnelInterface> tunnelInterfaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withTunnelInterfaces(tunnelInterfaces);
        return this;
    }

    public List<LoadBalancerBackendAddress> loadBalancerBackendAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancerBackendAddresses();
    }

    public BackendAddressPoolInner withLoadBalancerBackendAddresses(List<LoadBalancerBackendAddress> loadBalancerBackendAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackendAddressPoolPropertiesFormat();
        }
        this.innerProperties().withLoadBalancerBackendAddresses(loadBalancerBackendAddresses);
        return this;
    }

    public List<NetworkInterfaceIpConfigurationInner> backendIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().backendIpConfigurations();
    }

    public List<SubResource> loadBalancingRules() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingRules();
    }

    public SubResource outboundRule() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRule();
    }

    public List<SubResource> outboundRules() {
        return this.innerProperties() == null ? null : this.innerProperties().outboundRules();
    }

    public List<SubResource> inboundNatRules() {
        return this.innerProperties() == null ? null : this.innerProperties().inboundNatRules();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

