// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubId;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** ExpressRoute gateway resource. */
@Fluent
public final class ExpressRouteGatewayInner extends Resource {
    /*
     * Properties of the express route gateway.
     */
    @JsonProperty(value = "properties")
    private ExpressRouteGatewayProperties innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource ID.
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the innerProperties property: Properties of the express route gateway.
     *
     * @return the innerProperties value.
     */
    private ExpressRouteGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the id property: Resource ID.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID.
     *
     * @param id the id value to set.
     * @return the ExpressRouteGatewayInner object itself.
     */
    public ExpressRouteGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExpressRouteGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ExpressRouteGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the autoScaleConfiguration property: Configuration for auto scaling.
     *
     * @return the autoScaleConfiguration value.
     */
    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleConfiguration();
    }

    /**
     * Set the autoScaleConfiguration property: Configuration for auto scaling.
     *
     * @param autoScaleConfiguration the autoScaleConfiguration value to set.
     * @return the ExpressRouteGatewayInner object itself.
     */
    public ExpressRouteGatewayInner withAutoScaleConfiguration(
        ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withAutoScaleConfiguration(autoScaleConfiguration);
        return this;
    }

    /**
     * Get the expressRouteConnections property: List of ExpressRoute connections to the ExpressRoute gateway.
     *
     * @return the expressRouteConnections value.
     */
    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteConnections();
    }

    /**
     * Set the expressRouteConnections property: List of ExpressRoute connections to the ExpressRoute gateway.
     *
     * @param expressRouteConnections the expressRouteConnections value to set.
     * @return the ExpressRouteGatewayInner object itself.
     */
    public ExpressRouteGatewayInner withExpressRouteConnections(
        List<ExpressRouteConnectionInner> expressRouteConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withExpressRouteConnections(expressRouteConnections);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route gateway resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the virtualHub property: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     *
     * @return the virtualHub value.
     */
    public VirtualHubId virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    /**
     * Set the virtualHub property: The Virtual Hub where the ExpressRoute gateway is or will be deployed.
     *
     * @param virtualHub the virtualHub value to set.
     * @return the ExpressRouteGatewayInner object itself.
     */
    public ExpressRouteGatewayInner withVirtualHub(VirtualHubId virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
