// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ExpressRoutePortAuthorizationUseStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** ExpressRoute Port Authorization ExpressRoutePort Authorization resource definition. */
@Fluent
public final class ExpressRoutePortAuthorizationInner extends SubResource {
    /*
     * ExpressRoute Port Authorization Properties ExpressRoutePort properties.
     */
    @JsonProperty(value = "properties")
    private ExpressRoutePortAuthorizationPropertiesFormat innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This
     * name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Type of the resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the innerProperties property: ExpressRoute Port Authorization Properties ExpressRoutePort properties.
     *
     * @return the innerProperties value.
     */
    private ExpressRoutePortAuthorizationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the ExpressRoutePortAuthorizationInner object itself.
     */
    public ExpressRoutePortAuthorizationInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public ExpressRoutePortAuthorizationInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the authorizationKey property: The authorization key.
     *
     * @return the authorizationKey value.
     */
    public String authorizationKey() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationKey();
    }

    /**
     * Get the authorizationUseStatus property: The authorization use status.
     *
     * @return the authorizationUseStatus value.
     */
    public ExpressRoutePortAuthorizationUseStatus authorizationUseStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().authorizationUseStatus();
    }

    /**
     * Get the circuitResourceUri property: The reference to the ExpressRoute circuit resource using the authorization.
     *
     * @return the circuitResourceUri value.
     */
    public String circuitResourceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().circuitResourceUri();
    }

    /**
     * Get the provisioningState property: The provisioning state of the authorization resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
