// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.PeerRoute;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** List of virtual router peer routes. */
@Fluent
public final class PeerRouteListInner {
    /*
     * List of peer routes.
     */
    @JsonProperty(value = "value")
    private List<PeerRoute> value;

    /**
     * Get the value property: List of peer routes.
     *
     * @return the value value.
     */
    public List<PeerRoute> value() {
        return this.value;
    }

    /**
     * Set the value property: List of peer routes.
     *
     * @param value the value value to set.
     * @return the PeerRouteListInner object itself.
     */
    public PeerRouteListInner withValue(List<PeerRoute> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
