// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for FirewallPolicyIdpsSignatureMode. */
public enum FirewallPolicyIdpsSignatureMode {
    /** Enum value 0. */
    ZERO(0),

    /** Enum value 1. */
    ONE(1),

    /** Enum value 2. */
    TWO(2);

    /** The actual serialized value for a FirewallPolicyIdpsSignatureMode instance. */
    private final int value;

    FirewallPolicyIdpsSignatureMode(int value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a FirewallPolicyIdpsSignatureMode instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed FirewallPolicyIdpsSignatureMode object, or null if unable to parse.
     */
    @JsonCreator
    public static FirewallPolicyIdpsSignatureMode fromInt(int value) {
        FirewallPolicyIdpsSignatureMode[] items = FirewallPolicyIdpsSignatureMode.values();
        for (FirewallPolicyIdpsSignatureMode item : items) {
            if (item.toInt() == value) {
                return item;
            }
        }
        return null;
    }

    /**
     * De-serializes the instance to int value.
     *
     * @return the int value.
     */
    @JsonValue
    public int toInt() {
        return this.value;
    }
}
