// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for WebApplicationFirewallAction. */
public final class WebApplicationFirewallAction extends ExpandableStringEnum<WebApplicationFirewallAction> {
    /** Static value Allow for WebApplicationFirewallAction. */
    public static final WebApplicationFirewallAction ALLOW = fromString("Allow");

    /** Static value Block for WebApplicationFirewallAction. */
    public static final WebApplicationFirewallAction BLOCK = fromString("Block");

    /** Static value Log for WebApplicationFirewallAction. */
    public static final WebApplicationFirewallAction LOG = fromString("Log");

    /**
     * Creates or finds a WebApplicationFirewallAction from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WebApplicationFirewallAction.
     */
    @JsonCreator
    public static WebApplicationFirewallAction fromString(String name) {
        return fromString(name, WebApplicationFirewallAction.class);
    }

    /**
     * Gets known WebApplicationFirewallAction values.
     *
     * @return known WebApplicationFirewallAction values.
     */
    public static Collection<WebApplicationFirewallAction> values() {
        return values(WebApplicationFirewallAction.class);
    }
}
