// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.VpnServerConfigurationPolicyGroupInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ConfigurationPolicyGroupsClient. */
public interface ConfigurationPolicyGroupsClient {
    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters);

    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of vpnServerConfigurationPolicyGroup Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VpnServerConfigurationPolicyGroupInner>, VpnServerConfigurationPolicyGroupInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String vpnServerConfigurationName,
            String configurationPolicyGroupName,
            VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters);

    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of vpnServerConfigurationPolicyGroup Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnServerConfigurationPolicyGroupInner>, VpnServerConfigurationPolicyGroupInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String vpnServerConfigurationName,
            String configurationPolicyGroupName,
            VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters);

    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of vpnServerConfigurationPolicyGroup Resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnServerConfigurationPolicyGroupInner>, VpnServerConfigurationPolicyGroupInner>
        beginCreateOrUpdate(
            String resourceGroupName,
            String vpnServerConfigurationName,
            String configurationPolicyGroupName,
            VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters,
            Context context);

    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VpnServerConfigurationPolicyGroupInner> createOrUpdateAsync(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters);

    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnServerConfigurationPolicyGroupInner createOrUpdate(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters);

    /**
     * Creates a ConfigurationPolicyGroup if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationPolicyGroupParameters Parameters supplied to create or update a
     *     VpnServerConfiguration PolicyGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnServerConfigurationPolicyGroupInner createOrUpdate(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        VpnServerConfigurationPolicyGroupInner vpnServerConfigurationPolicyGroupParameters,
        Context context);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        Context context);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Deletes a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the ConfigurationPolicyGroup.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        Context context);

    /**
     * Retrieves the details of a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VpnServerConfigurationPolicyGroupInner>> getWithResponseAsync(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Retrieves the details of a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VpnServerConfigurationPolicyGroupInner> getAsync(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Retrieves the details of a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup being retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnServerConfigurationPolicyGroupInner get(
        String resourceGroupName, String vpnServerConfigurationName, String configurationPolicyGroupName);

    /**
     * Retrieves the details of a ConfigurationPolicyGroup.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param configurationPolicyGroupName The name of the ConfigurationPolicyGroup being retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vpnServerConfigurationPolicyGroup Resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VpnServerConfigurationPolicyGroupInner> getWithResponse(
        String resourceGroupName,
        String vpnServerConfigurationName,
        String configurationPolicyGroupName,
        Context context);

    /**
     * Lists all the configurationPolicyGroups in a resource group for a vpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list VpnServerConfigurationPolicyGroups as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VpnServerConfigurationPolicyGroupInner> listByVpnServerConfigurationAsync(
        String resourceGroupName, String vpnServerConfigurationName);

    /**
     * Lists all the configurationPolicyGroups in a resource group for a vpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list VpnServerConfigurationPolicyGroups as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VpnServerConfigurationPolicyGroupInner> listByVpnServerConfiguration(
        String resourceGroupName, String vpnServerConfigurationName);

    /**
     * Lists all the configurationPolicyGroups in a resource group for a vpnServerConfiguration.
     *
     * @param resourceGroupName The resource group name of the VpnServerConfiguration.
     * @param vpnServerConfigurationName The name of the VpnServerConfiguration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list VpnServerConfigurationPolicyGroups as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VpnServerConfigurationPolicyGroupInner> listByVpnServerConfiguration(
        String resourceGroupName, String vpnServerConfigurationName, Context context);
}
