// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of Frontend IP Configuration of the load balancer. */
@Fluent
public final class FrontendIpConfigurationPropertiesFormatInner {
    /*
     * An array of references to inbound rules that use this frontend IP.
     */
    @JsonProperty(value = "inboundNatRules", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> inboundNatRules;

    /*
     * An array of references to inbound pools that use this frontend IP.
     */
    @JsonProperty(value = "inboundNatPools", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> inboundNatPools;

    /*
     * An array of references to outbound rules that use this frontend IP.
     */
    @JsonProperty(value = "outboundRules", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> outboundRules;

    /*
     * An array of references to load balancing rules that use this frontend
     * IP.
     */
    @JsonProperty(value = "loadBalancingRules", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> loadBalancingRules;

    /*
     * The private IP address of the IP configuration.
     */
    @JsonProperty(value = "privateIPAddress")
    private String privateIpAddress;

    /*
     * The Private IP allocation method.
     */
    @JsonProperty(value = "privateIPAllocationMethod")
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken
     * as IPv4.
     */
    @JsonProperty(value = "privateIPAddressVersion")
    private IpVersion privateIpAddressVersion;

    /*
     * The reference to the subnet resource.
     */
    @JsonProperty(value = "subnet")
    private SubnetInner subnet;

    /*
     * The reference to the Public IP resource.
     */
    @JsonProperty(value = "publicIPAddress")
    private PublicIpAddressInner publicIpAddress;

    /*
     * The reference to the Public IP Prefix resource.
     */
    @JsonProperty(value = "publicIPPrefix")
    private SubResource publicIpPrefix;

    /*
     * The reference to gateway load balancer frontend IP.
     */
    @JsonProperty(value = "gatewayLoadBalancer")
    private SubResource gatewayLoadBalancer;

    /*
     * The provisioning state of the frontend IP configuration resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the inboundNatRules property: An array of references to inbound rules that use this frontend IP.
     *
     * @return the inboundNatRules value.
     */
    public List<SubResource> inboundNatRules() {
        return this.inboundNatRules;
    }

    /**
     * Get the inboundNatPools property: An array of references to inbound pools that use this frontend IP.
     *
     * @return the inboundNatPools value.
     */
    public List<SubResource> inboundNatPools() {
        return this.inboundNatPools;
    }

    /**
     * Get the outboundRules property: An array of references to outbound rules that use this frontend IP.
     *
     * @return the outboundRules value.
     */
    public List<SubResource> outboundRules() {
        return this.outboundRules;
    }

    /**
     * Get the loadBalancingRules property: An array of references to load balancing rules that use this frontend IP.
     *
     * @return the loadBalancingRules value.
     */
    public List<SubResource> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    /**
     * Get the privateIpAddress property: The private IP address of the IP configuration.
     *
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: The private IP address of the IP configuration.
     *
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The Private IP allocation method.
     *
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The Private IP allocation method.
     *
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAllocationMethod(
        IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the privateIpAddressVersion property: Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken
     * as IPv4.
     *
     * @return the privateIpAddressVersion value.
     */
    public IpVersion privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    /**
     * Set the privateIpAddressVersion property: Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken
     * as IPv4.
     *
     * @param privateIpAddressVersion the privateIpAddressVersion value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPrivateIpAddressVersion(IpVersion privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    /**
     * Get the subnet property: The reference to the subnet resource.
     *
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the subnet resource.
     *
     * @param subnet the subnet value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the publicIpAddress property: The reference to the Public IP resource.
     *
     * @return the publicIpAddress value.
     */
    public PublicIpAddressInner publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: The reference to the Public IP resource.
     *
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPublicIpAddress(PublicIpAddressInner publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the publicIpPrefix property: The reference to the Public IP Prefix resource.
     *
     * @return the publicIpPrefix value.
     */
    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    /**
     * Set the publicIpPrefix property: The reference to the Public IP Prefix resource.
     *
     * @param publicIpPrefix the publicIpPrefix value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    /**
     * Get the gatewayLoadBalancer property: The reference to gateway load balancer frontend IP.
     *
     * @return the gatewayLoadBalancer value.
     */
    public SubResource gatewayLoadBalancer() {
        return this.gatewayLoadBalancer;
    }

    /**
     * Set the gatewayLoadBalancer property: The reference to gateway load balancer frontend IP.
     *
     * @param gatewayLoadBalancer the gatewayLoadBalancer value to set.
     * @return the FrontendIpConfigurationPropertiesFormatInner object itself.
     */
    public FrontendIpConfigurationPropertiesFormatInner withGatewayLoadBalancer(SubResource gatewayLoadBalancer) {
        this.gatewayLoadBalancer = gatewayLoadBalancer;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the frontend IP configuration resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
        if (publicIpAddress() != null) {
            publicIpAddress().validate();
        }
    }
}
