// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.IpAllocationType;
import com.azure.resourcemanager.network.models.IpVersion;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Properties of the IpAllocation. */
@Fluent
public final class IpAllocationPropertiesFormat {
    /*
     * The Subnet that using the prefix of this IpAllocation resource.
     */
    @JsonProperty(value = "subnet", access = JsonProperty.Access.WRITE_ONLY)
    private SubResource subnet;

    /*
     * The VirtualNetwork that using the prefix of this IpAllocation resource.
     */
    @JsonProperty(value = "virtualNetwork", access = JsonProperty.Access.WRITE_ONLY)
    private SubResource virtualNetwork;

    /*
     * The type for the IpAllocation.
     */
    @JsonProperty(value = "type")
    private IpAllocationType type;

    /*
     * The address prefix for the IpAllocation.
     */
    @JsonProperty(value = "prefix")
    private String prefix;

    /*
     * The address prefix length for the IpAllocation.
     */
    @JsonProperty(value = "prefixLength")
    private Integer prefixLength;

    /*
     * The address prefix Type for the IpAllocation.
     */
    @JsonProperty(value = "prefixType")
    private IpVersion prefixType;

    /*
     * The IPAM allocation ID.
     */
    @JsonProperty(value = "ipamAllocationId")
    private String ipamAllocationId;

    /*
     * IpAllocation tags.
     */
    @JsonProperty(value = "allocationTags")
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, String> allocationTags;

    /**
     * Get the subnet property: The Subnet that using the prefix of this IpAllocation resource.
     *
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Get the virtualNetwork property: The VirtualNetwork that using the prefix of this IpAllocation resource.
     *
     * @return the virtualNetwork value.
     */
    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    /**
     * Get the type property: The type for the IpAllocation.
     *
     * @return the type value.
     */
    public IpAllocationType type() {
        return this.type;
    }

    /**
     * Set the type property: The type for the IpAllocation.
     *
     * @param type the type value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withType(IpAllocationType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the prefix property: The address prefix for the IpAllocation.
     *
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The address prefix for the IpAllocation.
     *
     * @param prefix the prefix value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the prefixLength property: The address prefix length for the IpAllocation.
     *
     * @return the prefixLength value.
     */
    public Integer prefixLength() {
        return this.prefixLength;
    }

    /**
     * Set the prefixLength property: The address prefix length for the IpAllocation.
     *
     * @param prefixLength the prefixLength value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    /**
     * Get the prefixType property: The address prefix Type for the IpAllocation.
     *
     * @return the prefixType value.
     */
    public IpVersion prefixType() {
        return this.prefixType;
    }

    /**
     * Set the prefixType property: The address prefix Type for the IpAllocation.
     *
     * @param prefixType the prefixType value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withPrefixType(IpVersion prefixType) {
        this.prefixType = prefixType;
        return this;
    }

    /**
     * Get the ipamAllocationId property: The IPAM allocation ID.
     *
     * @return the ipamAllocationId value.
     */
    public String ipamAllocationId() {
        return this.ipamAllocationId;
    }

    /**
     * Set the ipamAllocationId property: The IPAM allocation ID.
     *
     * @param ipamAllocationId the ipamAllocationId value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withIpamAllocationId(String ipamAllocationId) {
        this.ipamAllocationId = ipamAllocationId;
        return this;
    }

    /**
     * Get the allocationTags property: IpAllocation tags.
     *
     * @return the allocationTags value.
     */
    public Map<String, String> allocationTags() {
        return this.allocationTags;
    }

    /**
     * Set the allocationTags property: IpAllocation tags.
     *
     * @param allocationTags the allocationTags value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withAllocationTags(Map<String, String> allocationTags) {
        this.allocationTags = allocationTags;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
