// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.network.models.NetworkConfigurationDiagnosticResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Results of network configuration diagnostic on the target resource. */
@Immutable
public final class NetworkConfigurationDiagnosticResponseInner {
    /*
     * List of network configuration diagnostic results.
     */
    @JsonProperty(value = "results", access = JsonProperty.Access.WRITE_ONLY)
    private List<NetworkConfigurationDiagnosticResult> results;

    /**
     * Get the results property: List of network configuration diagnostic results.
     *
     * @return the results value.
     */
    public List<NetworkConfigurationDiagnosticResult> results() {
        return this.results;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (results() != null) {
            results().forEach(e -> e.validate());
        }
    }
}
