// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.DdosSettings;
import com.azure.resourcemanager.network.models.DeleteOptions;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.network.models.PublicIpAddressMigrationPhase;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Public IP address properties. */
@Fluent
public final class PublicIpAddressPropertiesFormatInner {
    /*
     * The public IP address allocation method.
     */
    @JsonProperty(value = "publicIPAllocationMethod")
    private IpAllocationMethod publicIpAllocationMethod;

    /*
     * The public IP address version.
     */
    @JsonProperty(value = "publicIPAddressVersion")
    private IpVersion publicIpAddressVersion;

    /*
     * The IP configuration associated with the public IP address.
     */
    @JsonProperty(value = "ipConfiguration", access = JsonProperty.Access.WRITE_ONLY)
    private IpConfigurationInner ipConfiguration;

    /*
     * The FQDN of the DNS record associated with the public IP address.
     */
    @JsonProperty(value = "dnsSettings")
    private PublicIpAddressDnsSettings dnsSettings;

    /*
     * The DDoS protection custom policy associated with the public IP address.
     */
    @JsonProperty(value = "ddosSettings")
    private DdosSettings ddosSettings;

    /*
     * The list of tags associated with the public IP address.
     */
    @JsonProperty(value = "ipTags")
    private List<IpTag> ipTags;

    /*
     * The IP address associated with the public IP address resource.
     */
    @JsonProperty(value = "ipAddress")
    private String ipAddress;

    /*
     * The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JsonProperty(value = "publicIPPrefix")
    private SubResource publicIpPrefix;

    /*
     * The idle timeout of the public IP address.
     */
    @JsonProperty(value = "idleTimeoutInMinutes")
    private Integer idleTimeoutInMinutes;

    /*
     * The resource GUID property of the public IP address resource.
     */
    @JsonProperty(value = "resourceGuid", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    /*
     * The provisioning state of the public IP address resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The service public IP address of the public IP address resource.
     */
    @JsonProperty(value = "servicePublicIPAddress")
    private PublicIpAddressInner servicePublicIpAddress;

    /*
     * The NatGateway for the Public IP address.
     */
    @JsonProperty(value = "natGateway")
    private NatGatewayInner natGateway;

    /*
     * Migration phase of Public IP Address.
     */
    @JsonProperty(value = "migrationPhase")
    private PublicIpAddressMigrationPhase migrationPhase;

    /*
     * The linked public IP address of the public IP address resource.
     */
    @JsonProperty(value = "linkedPublicIPAddress")
    private PublicIpAddressInner linkedPublicIpAddress;

    /*
     * Specify what happens to the public IP address when the VM using it is
     * deleted
     */
    @JsonProperty(value = "deleteOption")
    private DeleteOptions deleteOption;

    /**
     * Get the publicIpAllocationMethod property: The public IP address allocation method.
     *
     * @return the publicIpAllocationMethod value.
     */
    public IpAllocationMethod publicIpAllocationMethod() {
        return this.publicIpAllocationMethod;
    }

    /**
     * Set the publicIpAllocationMethod property: The public IP address allocation method.
     *
     * @param publicIpAllocationMethod the publicIpAllocationMethod value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withPublicIpAllocationMethod(
        IpAllocationMethod publicIpAllocationMethod) {
        this.publicIpAllocationMethod = publicIpAllocationMethod;
        return this;
    }

    /**
     * Get the publicIpAddressVersion property: The public IP address version.
     *
     * @return the publicIpAddressVersion value.
     */
    public IpVersion publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    /**
     * Set the publicIpAddressVersion property: The public IP address version.
     *
     * @param publicIpAddressVersion the publicIpAddressVersion value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withPublicIpAddressVersion(IpVersion publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    /**
     * Get the ipConfiguration property: The IP configuration associated with the public IP address.
     *
     * @return the ipConfiguration value.
     */
    public IpConfigurationInner ipConfiguration() {
        return this.ipConfiguration;
    }

    /**
     * Get the dnsSettings property: The FQDN of the DNS record associated with the public IP address.
     *
     * @return the dnsSettings value.
     */
    public PublicIpAddressDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    /**
     * Set the dnsSettings property: The FQDN of the DNS record associated with the public IP address.
     *
     * @param dnsSettings the dnsSettings value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withDnsSettings(PublicIpAddressDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    /**
     * Get the ddosSettings property: The DDoS protection custom policy associated with the public IP address.
     *
     * @return the ddosSettings value.
     */
    public DdosSettings ddosSettings() {
        return this.ddosSettings;
    }

    /**
     * Set the ddosSettings property: The DDoS protection custom policy associated with the public IP address.
     *
     * @param ddosSettings the ddosSettings value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withDdosSettings(DdosSettings ddosSettings) {
        this.ddosSettings = ddosSettings;
        return this;
    }

    /**
     * Get the ipTags property: The list of tags associated with the public IP address.
     *
     * @return the ipTags value.
     */
    public List<IpTag> ipTags() {
        return this.ipTags;
    }

    /**
     * Set the ipTags property: The list of tags associated with the public IP address.
     *
     * @param ipTags the ipTags value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withIpTags(List<IpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    /**
     * Get the ipAddress property: The IP address associated with the public IP address resource.
     *
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The IP address associated with the public IP address resource.
     *
     * @param ipAddress the ipAddress value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the publicIpPrefix property: The Public IP Prefix this Public IP Address should be allocated from.
     *
     * @return the publicIpPrefix value.
     */
    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    /**
     * Set the publicIpPrefix property: The Public IP Prefix this Public IP Address should be allocated from.
     *
     * @param publicIpPrefix the publicIpPrefix value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    /**
     * Get the idleTimeoutInMinutes property: The idle timeout of the public IP address.
     *
     * @return the idleTimeoutInMinutes value.
     */
    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    /**
     * Set the idleTimeoutInMinutes property: The idle timeout of the public IP address.
     *
     * @param idleTimeoutInMinutes the idleTimeoutInMinutes value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the public IP address resource.
     *
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the public IP address resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the servicePublicIpAddress property: The service public IP address of the public IP address resource.
     *
     * @return the servicePublicIpAddress value.
     */
    public PublicIpAddressInner servicePublicIpAddress() {
        return this.servicePublicIpAddress;
    }

    /**
     * Set the servicePublicIpAddress property: The service public IP address of the public IP address resource.
     *
     * @param servicePublicIpAddress the servicePublicIpAddress value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withServicePublicIpAddress(
        PublicIpAddressInner servicePublicIpAddress) {
        this.servicePublicIpAddress = servicePublicIpAddress;
        return this;
    }

    /**
     * Get the natGateway property: The NatGateway for the Public IP address.
     *
     * @return the natGateway value.
     */
    public NatGatewayInner natGateway() {
        return this.natGateway;
    }

    /**
     * Set the natGateway property: The NatGateway for the Public IP address.
     *
     * @param natGateway the natGateway value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withNatGateway(NatGatewayInner natGateway) {
        this.natGateway = natGateway;
        return this;
    }

    /**
     * Get the migrationPhase property: Migration phase of Public IP Address.
     *
     * @return the migrationPhase value.
     */
    public PublicIpAddressMigrationPhase migrationPhase() {
        return this.migrationPhase;
    }

    /**
     * Set the migrationPhase property: Migration phase of Public IP Address.
     *
     * @param migrationPhase the migrationPhase value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withMigrationPhase(PublicIpAddressMigrationPhase migrationPhase) {
        this.migrationPhase = migrationPhase;
        return this;
    }

    /**
     * Get the linkedPublicIpAddress property: The linked public IP address of the public IP address resource.
     *
     * @return the linkedPublicIpAddress value.
     */
    public PublicIpAddressInner linkedPublicIpAddress() {
        return this.linkedPublicIpAddress;
    }

    /**
     * Set the linkedPublicIpAddress property: The linked public IP address of the public IP address resource.
     *
     * @param linkedPublicIpAddress the linkedPublicIpAddress value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withLinkedPublicIpAddress(PublicIpAddressInner linkedPublicIpAddress) {
        this.linkedPublicIpAddress = linkedPublicIpAddress;
        return this;
    }

    /**
     * Get the deleteOption property: Specify what happens to the public IP address when the VM using it is deleted.
     *
     * @return the deleteOption value.
     */
    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    /**
     * Set the deleteOption property: Specify what happens to the public IP address when the VM using it is deleted.
     *
     * @param deleteOption the deleteOption value to set.
     * @return the PublicIpAddressPropertiesFormatInner object itself.
     */
    public PublicIpAddressPropertiesFormatInner withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipConfiguration() != null) {
            ipConfiguration().validate();
        }
        if (dnsSettings() != null) {
            dnsSettings().validate();
        }
        if (ddosSettings() != null) {
            ddosSettings().validate();
        }
        if (ipTags() != null) {
            ipTags().forEach(e -> e.validate());
        }
        if (servicePublicIpAddress() != null) {
            servicePublicIpAddress().validate();
        }
        if (natGateway() != null) {
            natGateway().validate();
        }
        if (linkedPublicIpAddress() != null) {
            linkedPublicIpAddress().validate();
        }
    }
}
