// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayBackendSettingsPropertiesFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Backend address pool settings of an application gateway. */
@Fluent
public final class ApplicationGatewayBackendSettings extends SubResource {
    /*
     * Properties of the application gateway backend settings.
     */
    @JsonProperty(value = "properties")
    private ApplicationGatewayBackendSettingsPropertiesFormat innerProperties;

    /*
     * Name of the backend settings that is unique within an Application
     * Gateway.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Type of the resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the innerProperties property: Properties of the application gateway backend settings.
     *
     * @return the innerProperties value.
     */
    private ApplicationGatewayBackendSettingsPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the backend settings that is unique within an Application Gateway.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the backend settings that is unique within an Application Gateway.
     *
     * @param name the name value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public ApplicationGatewayBackendSettings withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the port property: The destination port on the backend.
     *
     * @return the port value.
     */
    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    /**
     * Set the port property: The destination port on the backend.
     *
     * @param port the port value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withPort(Integer port) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withPort(port);
        return this;
    }

    /**
     * Get the protocol property: The protocol used to communicate with the backend.
     *
     * @return the protocol value.
     */
    public ApplicationGatewayProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    /**
     * Set the protocol property: The protocol used to communicate with the backend.
     *
     * @param protocol the protocol value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withProtocol(ApplicationGatewayProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    /**
     * Get the timeout property: Connection timeout in seconds. Application Gateway will fail the request if response is
     * not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     *
     * @return the timeout value.
     */
    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    /**
     * Set the timeout property: Connection timeout in seconds. Application Gateway will fail the request if response is
     * not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     *
     * @param timeout the timeout value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withTimeout(Integer timeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withTimeout(timeout);
        return this;
    }

    /**
     * Get the probe property: Probe resource of an application gateway.
     *
     * @return the probe value.
     */
    public SubResource probe() {
        return this.innerProperties() == null ? null : this.innerProperties().probe();
    }

    /**
     * Set the probe property: Probe resource of an application gateway.
     *
     * @param probe the probe value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withProbe(SubResource probe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withProbe(probe);
        return this;
    }

    /**
     * Get the trustedRootCertificates property: Array of references to application gateway trusted root certificates.
     *
     * @return the trustedRootCertificates value.
     */
    public List<SubResource> trustedRootCertificates() {
        return this.innerProperties() == null ? null : this.innerProperties().trustedRootCertificates();
    }

    /**
     * Set the trustedRootCertificates property: Array of references to application gateway trusted root certificates.
     *
     * @param trustedRootCertificates the trustedRootCertificates value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withTrustedRootCertificates(List<SubResource> trustedRootCertificates) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withTrustedRootCertificates(trustedRootCertificates);
        return this;
    }

    /**
     * Get the hostname property: Server name indication to be sent to the backend servers for Tls protocol.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    /**
     * Set the hostname property: Server name indication to be sent to the backend servers for Tls protocol.
     *
     * @param hostname the hostname value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    /**
     * Get the pickHostnameFromBackendAddress property: Whether to pick server name indication from the host name of the
     * backend server for Tls protocol. Default value is false.
     *
     * @return the pickHostnameFromBackendAddress value.
     */
    public Boolean pickHostnameFromBackendAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().pickHostnameFromBackendAddress();
    }

    /**
     * Set the pickHostnameFromBackendAddress property: Whether to pick server name indication from the host name of the
     * backend server for Tls protocol. Default value is false.
     *
     * @param pickHostnameFromBackendAddress the pickHostnameFromBackendAddress value to set.
     * @return the ApplicationGatewayBackendSettings object itself.
     */
    public ApplicationGatewayBackendSettings withPickHostnameFromBackendAddress(
        Boolean pickHostnameFromBackendAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayBackendSettingsPropertiesFormat();
        }
        this.innerProperties().withPickHostnameFromBackendAddress(pickHostnameFromBackendAddress);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the backend HTTP settings resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
