// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.ContainerNetworkInterfacePropertiesFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Container network interface child resource. */
@Fluent
public final class ContainerNetworkInterface extends SubResource {
    /*
     * Container network interface properties.
     */
    @JsonProperty(value = "properties")
    private ContainerNetworkInterfacePropertiesFormat innerProperties;

    /*
     * The name of the resource. This name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Sub Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Get the innerProperties property: Container network interface properties.
     *
     * @return the innerProperties value.
     */
    private ContainerNetworkInterfacePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource. This name can be used to access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource. This name can be used to access the resource.
     *
     * @param name the name value to set.
     * @return the ContainerNetworkInterface object itself.
     */
    public ContainerNetworkInterface withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Sub Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /** {@inheritDoc} */
    @Override
    public ContainerNetworkInterface withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the containerNetworkInterfaceConfiguration property: Container network interface configuration from which
     * this container network interface is created.
     *
     * @return the containerNetworkInterfaceConfiguration value.
     */
    public ContainerNetworkInterfaceConfiguration containerNetworkInterfaceConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().containerNetworkInterfaceConfiguration();
    }

    /**
     * Get the container property: Reference to the container to which this container network interface is attached.
     *
     * @return the container value.
     */
    public Container container() {
        return this.innerProperties() == null ? null : this.innerProperties().container();
    }

    /**
     * Set the container property: Reference to the container to which this container network interface is attached.
     *
     * @param container the container value to set.
     * @return the ContainerNetworkInterface object itself.
     */
    public ContainerNetworkInterface withContainer(Container container) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerNetworkInterfacePropertiesFormat();
        }
        this.innerProperties().withContainer(container);
        return this;
    }

    /**
     * Get the ipConfigurations property: Reference to the ip configuration on this container nic.
     *
     * @return the ipConfigurations value.
     */
    public List<ContainerNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    /**
     * Get the provisioningState property: The provisioning state of the container network interface resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
