// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Results of network security group evaluation. */
@Fluent
public final class EvaluatedNetworkSecurityGroup {
    /*
     * Network security group ID.
     */
    @JsonProperty(value = "networkSecurityGroupId")
    private String networkSecurityGroupId;

    /*
     * Resource ID of nic or subnet to which network security group is applied.
     */
    @JsonProperty(value = "appliedTo")
    private String appliedTo;

    /*
     * Matched network security rule.
     */
    @JsonProperty(value = "matchedRule")
    private MatchedRule matchedRule;

    /*
     * List of network security rules evaluation results.
     */
    @JsonProperty(value = "rulesEvaluationResult", access = JsonProperty.Access.WRITE_ONLY)
    private List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult;

    /**
     * Get the networkSecurityGroupId property: Network security group ID.
     *
     * @return the networkSecurityGroupId value.
     */
    public String networkSecurityGroupId() {
        return this.networkSecurityGroupId;
    }

    /**
     * Set the networkSecurityGroupId property: Network security group ID.
     *
     * @param networkSecurityGroupId the networkSecurityGroupId value to set.
     * @return the EvaluatedNetworkSecurityGroup object itself.
     */
    public EvaluatedNetworkSecurityGroup withNetworkSecurityGroupId(String networkSecurityGroupId) {
        this.networkSecurityGroupId = networkSecurityGroupId;
        return this;
    }

    /**
     * Get the appliedTo property: Resource ID of nic or subnet to which network security group is applied.
     *
     * @return the appliedTo value.
     */
    public String appliedTo() {
        return this.appliedTo;
    }

    /**
     * Set the appliedTo property: Resource ID of nic or subnet to which network security group is applied.
     *
     * @param appliedTo the appliedTo value to set.
     * @return the EvaluatedNetworkSecurityGroup object itself.
     */
    public EvaluatedNetworkSecurityGroup withAppliedTo(String appliedTo) {
        this.appliedTo = appliedTo;
        return this;
    }

    /**
     * Get the matchedRule property: Matched network security rule.
     *
     * @return the matchedRule value.
     */
    public MatchedRule matchedRule() {
        return this.matchedRule;
    }

    /**
     * Set the matchedRule property: Matched network security rule.
     *
     * @param matchedRule the matchedRule value to set.
     * @return the EvaluatedNetworkSecurityGroup object itself.
     */
    public EvaluatedNetworkSecurityGroup withMatchedRule(MatchedRule matchedRule) {
        this.matchedRule = matchedRule;
        return this;
    }

    /**
     * Get the rulesEvaluationResult property: List of network security rules evaluation results.
     *
     * @return the rulesEvaluationResult value.
     */
    public List<NetworkSecurityRulesEvaluationResult> rulesEvaluationResult() {
        return this.rulesEvaluationResult;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchedRule() != null) {
            matchedRule().validate();
        }
        if (rulesEvaluationResult() != null) {
            rulesEvaluationResult().forEach(e -> e.validate());
        }
    }
}
