// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The HTTP header. */
@Fluent
public final class HttpHeader {
    /*
     * The name in HTTP header.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The value in HTTP header.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Get the name property: The name in HTTP header.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name in HTTP header.
     *
     * @param name the name value to set.
     * @return the HttpHeader object itself.
     */
    public HttpHeader withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value in HTTP header.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value in HTTP header.
     *
     * @param value the value value to set.
     * @return the HttpHeader object itself.
     */
    public HttpHeader withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
