/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ConnectivityConfigurationsClient;
import com.azure.resourcemanager.network.fluent.models.ConnectivityConfigurationInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ConnectivityConfigurationListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConnectivityConfigurationsClientImpl
implements ConnectivityConfigurationsClient {
    private final ConnectivityConfigurationsService service;
    private final NetworkManagementClientImpl client;

    ConnectivityConfigurationsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ConnectivityConfigurationsService)RestProxy.create(ConnectivityConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectivityConfigurationInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectivityConfigurationInner>> getWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectivityConfigurationInner> getAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        return this.getWithResponseAsync(resourceGroupName, networkManagerName, configurationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectivityConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectivityConfigurationInner get(String resourceGroupName, String networkManagerName, String configurationName) {
        return (ConnectivityConfigurationInner)((Object)this.getAsync(resourceGroupName, networkManagerName, configurationName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectivityConfigurationInner> getWithResponse(String resourceGroupName, String networkManagerName, String configurationName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, networkManagerName, configurationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectivityConfigurationInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, ConnectivityConfigurationInner connectivityConfiguration) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (connectivityConfiguration == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectivityConfiguration is required and cannot be null."));
        }
        connectivityConfiguration.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, connectivityConfiguration, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectivityConfigurationInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, ConnectivityConfigurationInner connectivityConfiguration, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        if (connectivityConfiguration == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectivityConfiguration is required and cannot be null."));
        }
        connectivityConfiguration.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, connectivityConfiguration, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectivityConfigurationInner> createOrUpdateAsync(String resourceGroupName, String networkManagerName, String configurationName, ConnectivityConfigurationInner connectivityConfiguration) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, networkManagerName, configurationName, connectivityConfiguration).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectivityConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectivityConfigurationInner createOrUpdate(String resourceGroupName, String networkManagerName, String configurationName, ConnectivityConfigurationInner connectivityConfiguration) {
        return (ConnectivityConfigurationInner)((Object)this.createOrUpdateAsync(resourceGroupName, networkManagerName, configurationName, connectivityConfiguration).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectivityConfigurationInner> createOrUpdateWithResponse(String resourceGroupName, String networkManagerName, String configurationName, ConnectivityConfigurationInner connectivityConfiguration, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, networkManagerName, configurationName, connectivityConfiguration, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, force, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        if (configurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configurationName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, configurationName, force, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, configurationName, force);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, networkManagerName, configurationName, force, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String configurationName) {
        Boolean force = null;
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        return this.beginDeleteAsync(resourceGroupName, networkManagerName, configurationName, force, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String configurationName, Boolean force) {
        this.deleteAsync(resourceGroupName, networkManagerName, configurationName, force).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String configurationName) {
        Boolean force = null;
        this.deleteAsync(resourceGroupName, networkManagerName, configurationName, force).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkManagerName, String configurationName, Boolean force, Context context) {
        this.deleteAsync(resourceGroupName, networkManagerName, configurationName, force, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectivityConfigurationInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectivityConfigurationListResult)res.getValue()).value(), ((ConnectivityConfigurationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectivityConfigurationInner>> listSinglePageAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkManagerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter networkManagerName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), resourceGroupName, networkManagerName, top, skipToken, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectivityConfigurationListResult)res.getValue()).value(), ((ConnectivityConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConnectivityConfigurationInner> listAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConnectivityConfigurationInner> listAsync(String resourceGroupName, String networkManagerName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConnectivityConfigurationInner> listAsync(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, networkManagerName, top, skipToken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectivityConfigurationInner> list(String resourceGroupName, String networkManagerName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, top, skipToken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConnectivityConfigurationInner> list(String resourceGroupName, String networkManagerName, Integer top, String skipToken, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, networkManagerName, top, skipToken, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectivityConfigurationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectivityConfigurationListResult)res.getValue()).value(), ((ConnectivityConfigurationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConnectivityConfigurationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConnectivityConfigurationListResult)res.getValue()).value(), ((ConnectivityConfigurationListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface ConnectivityConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/connectivityConfigurations/{configurationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectivityConfigurationInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="configurationName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/connectivityConfigurations/{configurationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectivityConfigurationInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="configurationName") String var6, @BodyParam(value="application/json") ConnectivityConfigurationInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/connectivityConfigurations/{configurationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @PathParam(value="configurationName") String var6, @QueryParam(value="force") Boolean var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/connectivityConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectivityConfigurationListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="networkManagerName") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConnectivityConfigurationListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

