/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.VirtualNetworkTapsClient;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkTapInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.network.models.VirtualNetworkTapListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualNetworkTapsClientImpl
implements InnerSupportsGet<VirtualNetworkTapInner>,
InnerSupportsListing<VirtualNetworkTapInner>,
InnerSupportsDelete<Void>,
VirtualNetworkTapsClient {
    private final VirtualNetworkTapsService service;
    private final NetworkManagementClientImpl client;

    VirtualNetworkTapsClientImpl(NetworkManagementClientImpl client) {
        this.service = (VirtualNetworkTapsService)RestProxy.create(VirtualNetworkTapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String tapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String tapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String tapName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, tapName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String tapName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, tapName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String tapName) {
        return this.beginDeleteAsync(resourceGroupName, tapName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String tapName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, tapName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String tapName) {
        return this.beginDeleteAsync(resourceGroupName, tapName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String tapName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, tapName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String tapName) {
        this.deleteAsync(resourceGroupName, tapName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String tapName, Context context) {
        this.deleteAsync(resourceGroupName, tapName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualNetworkTapInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String tapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualNetworkTapInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String tapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkTapInner> getByResourceGroupAsync(String resourceGroupName, String tapName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, tapName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VirtualNetworkTapInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkTapInner getByResourceGroup(String resourceGroupName, String tapName) {
        return (VirtualNetworkTapInner)((Object)this.getByResourceGroupAsync(resourceGroupName, tapName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualNetworkTapInner> getByResourceGroupWithResponse(String resourceGroupName, String tapName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, tapName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualNetworkTapInner>, VirtualNetworkTapInner> beginCreateOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, tapName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkTapInner.class), (Type)((Object)VirtualNetworkTapInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualNetworkTapInner>, VirtualNetworkTapInner> beginCreateOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, tapName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkTapInner.class), (Type)((Object)VirtualNetworkTapInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkTapInner>, VirtualNetworkTapInner> beginCreateOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, tapName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkTapInner>, VirtualNetworkTapInner> beginCreateOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, tapName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkTapInner> createOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, tapName, parameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualNetworkTapInner> createOrUpdateAsync(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, tapName, parameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkTapInner createOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters) {
        return (VirtualNetworkTapInner)((Object)this.createOrUpdateAsync(resourceGroupName, tapName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkTapInner createOrUpdate(String resourceGroupName, String tapName, VirtualNetworkTapInner parameters, Context context) {
        return (VirtualNetworkTapInner)((Object)this.createOrUpdateAsync(resourceGroupName, tapName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualNetworkTapInner>> updateTagsWithResponseAsync(String resourceGroupName, String tapName, TagsObject tapParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tapParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapParameters is required and cannot be null."));
        }
        tapParameters.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateTags(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), tapParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualNetworkTapInner>> updateTagsWithResponseAsync(String resourceGroupName, String tapName, TagsObject tapParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (tapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tapParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter tapParameters is required and cannot be null."));
        }
        tapParameters.validate();
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateTags(this.client.getEndpoint(), resourceGroupName, tapName, "2022-01-01", this.client.getSubscriptionId(), tapParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkTapInner> updateTagsAsync(String resourceGroupName, String tapName, TagsObject tapParameters) {
        return this.updateTagsWithResponseAsync(resourceGroupName, tapName, tapParameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VirtualNetworkTapInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkTapInner updateTags(String resourceGroupName, String tapName, TagsObject tapParameters) {
        return (VirtualNetworkTapInner)((Object)this.updateTagsAsync(resourceGroupName, tapName, tapParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualNetworkTapInner> updateTagsWithResponse(String resourceGroupName, String tapName, TagsObject tapParameters, Context context) {
        return (Response)this.updateTagsWithResponseAsync(resourceGroupName, tapName, tapParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2022-01-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualNetworkTapInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listAllNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkTapInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listAllNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkTapInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkTapInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2022-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, "2022-01-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualNetworkTapInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkTapInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkTapInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkTapInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listAllNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listAllNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAllNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkTapInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkTapListResult)res.getValue()).value(), ((VirtualNetworkTapListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    private static interface VirtualNetworkTapsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="tapName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkTapInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="tapName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="tapName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") VirtualNetworkTapInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkTapInner>> updateTags(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="tapName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @BodyParam(value="application/json") TagsObject var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/virtualNetworkTaps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkTapListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkTapListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkTapListResult>> listAllNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkTapListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

