// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.RouteMapsClient;
import com.azure.resourcemanager.network.fluent.models.RouteMapInner;
import com.azure.resourcemanager.network.models.ListRouteMapsResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in RouteMapsClient. */
public final class RouteMapsClientImpl implements RouteMapsClient {
    /** The proxy service used to perform REST calls. */
    private final RouteMapsService service;

    /** The service client containing this operation class. */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of RouteMapsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    RouteMapsClientImpl(NetworkManagementClientImpl client) {
        this.service =
            RestProxy.create(RouteMapsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientRouteMaps to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementCli")
    public interface RouteMapsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs"
                + "/{virtualHubName}/routeMaps/{routeMapName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<RouteMapInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @PathParam("routeMapName") String routeMapName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs"
                + "/{virtualHubName}/routeMaps/{routeMapName}")
        @ExpectedResponses({200, 201})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @PathParam("routeMapName") String routeMapName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RouteMapInner routeMapParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs"
                + "/{virtualHubName}/routeMaps/{routeMapName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @PathParam("routeMapName") String routeMapName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs"
                + "/{virtualHubName}/routeMaps")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListRouteMapsResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("virtualHubName") String virtualHubName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListRouteMapsResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Retrieves the details of a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RouteMapInner>> getWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routeMapName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeMapName == null) {
            return Mono.error(new IllegalArgumentException("Parameter routeMapName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            routeMapName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the details of a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RouteMapInner>> getWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeMapName == null) {
            return Mono.error(new IllegalArgumentException("Parameter routeMapName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                routeMapName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Retrieves the details of a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RouteMapInner> getAsync(String resourceGroupName, String virtualHubName, String routeMapName) {
        return getWithResponseAsync(resourceGroupName, virtualHubName, routeMapName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves the details of a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RouteMapInner> getWithResponse(
        String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        return getWithResponseAsync(resourceGroupName, virtualHubName, routeMapName, context).block();
    }

    /**
     * Retrieves the details of a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RouteMapInner get(String resourceGroupName, String virtualHubName, String routeMapName) {
        return getWithResponse(resourceGroupName, virtualHubName, routeMapName, Context.NONE).getValue();
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, RouteMapInner routeMapParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeMapName == null) {
            return Mono.error(new IllegalArgumentException("Parameter routeMapName is required and cannot be null."));
        }
        if (routeMapParameters == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routeMapParameters is required and cannot be null."));
        } else {
            routeMapParameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            routeMapName,
                            apiVersion,
                            routeMapParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String virtualHubName,
        String routeMapName,
        RouteMapInner routeMapParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeMapName == null) {
            return Mono.error(new IllegalArgumentException("Parameter routeMapName is required and cannot be null."));
        }
        if (routeMapParameters == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter routeMapParameters is required and cannot be null."));
        } else {
            routeMapParameters.validate();
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                routeMapName,
                apiVersion,
                routeMapParameters,
                accept,
                context);
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, RouteMapInner routeMapParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters);
        return this
            .client
            .<RouteMapInner, RouteMapInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                RouteMapInner.class,
                RouteMapInner.class,
                this.client.getContext());
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdateAsync(
        String resourceGroupName,
        String virtualHubName,
        String routeMapName,
        RouteMapInner routeMapParameters,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, virtualHubName, routeMapName, routeMapParameters, context);
        return this
            .client
            .<RouteMapInner, RouteMapInner>getLroResult(
                mono, this.client.getHttpPipeline(), RouteMapInner.class, RouteMapInner.class, context);
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdate(
        String resourceGroupName, String virtualHubName, String routeMapName, RouteMapInner routeMapParameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters)
            .getSyncPoller();
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RouteMapInner>, RouteMapInner> beginCreateOrUpdate(
        String resourceGroupName,
        String virtualHubName,
        String routeMapName,
        RouteMapInner routeMapParameters,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters, context)
            .getSyncPoller();
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RouteMapInner> createOrUpdateAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, RouteMapInner routeMapParameters) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<RouteMapInner> createOrUpdateAsync(
        String resourceGroupName,
        String virtualHubName,
        String routeMapName,
        RouteMapInner routeMapParameters,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RouteMapInner createOrUpdate(
        String resourceGroupName, String virtualHubName, String routeMapName, RouteMapInner routeMapParameters) {
        return createOrUpdateAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters).block();
    }

    /**
     * Creates a RouteMap if it doesn't exist else updates the existing one.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param routeMapParameters Parameters supplied to create or update a RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RouteMap child resource of a Virtual hub.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RouteMapInner createOrUpdate(
        String resourceGroupName,
        String virtualHubName,
        String routeMapName,
        RouteMapInner routeMapParameters,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, virtualHubName, routeMapName, routeMapParameters, context)
            .block();
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routeMapName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeMapName == null) {
            return Mono.error(new IllegalArgumentException("Parameter routeMapName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            routeMapName,
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        if (routeMapName == null) {
            return Mono.error(new IllegalArgumentException("Parameter routeMapName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                routeMapName,
                apiVersion,
                accept,
                context);
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String virtualHubName, String routeMapName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, virtualHubName, routeMapName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, virtualHubName, routeMapName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String virtualHubName, String routeMapName) {
        return beginDeleteAsync(resourceGroupName, virtualHubName, routeMapName).getSyncPoller();
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        return beginDeleteAsync(resourceGroupName, virtualHubName, routeMapName, context).getSyncPoller();
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String virtualHubName, String routeMapName) {
        return beginDeleteAsync(resourceGroupName, virtualHubName, routeMapName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        return beginDeleteAsync(resourceGroupName, virtualHubName, routeMapName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routeMapName) {
        deleteAsync(resourceGroupName, virtualHubName, routeMapName).block();
    }

    /**
     * Deletes a RouteMap.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param routeMapName The name of the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String virtualHubName, String routeMapName, Context context) {
        deleteAsync(resourceGroupName, virtualHubName, routeMapName, context).block();
    }

    /**
     * Retrieves the details of all RouteMaps.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RouteMapInner>> listSinglePageAsync(String resourceGroupName, String virtualHubName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            virtualHubName,
                            apiVersion,
                            accept,
                            context))
            .<PagedResponse<RouteMapInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the details of all RouteMaps.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RouteMapInner>> listSinglePageAsync(
        String resourceGroupName, String virtualHubName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualHubName == null) {
            return Mono.error(new IllegalArgumentException("Parameter virtualHubName is required and cannot be null."));
        }
        final String apiVersion = "2022-07-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                virtualHubName,
                apiVersion,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Retrieves the details of all RouteMaps.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RouteMapInner> listAsync(String resourceGroupName, String virtualHubName) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, virtualHubName),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves the details of all RouteMaps.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RouteMapInner> listAsync(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, virtualHubName, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves the details of all RouteMaps.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RouteMapInner> list(String resourceGroupName, String virtualHubName) {
        return new PagedIterable<>(listAsync(resourceGroupName, virtualHubName));
    }

    /**
     * Retrieves the details of all RouteMaps.
     *
     * @param resourceGroupName The resource group name of the RouteMap's resource group'.
     * @param virtualHubName The name of the VirtualHub containing the RouteMap.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RouteMapInner> list(String resourceGroupName, String virtualHubName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, virtualHubName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RouteMapInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RouteMapInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of RouteMaps and a URL nextLink to get the next set of results along with {@link PagedResponse} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RouteMapInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
