// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The action type of a rule. */
public final class FirewallPolicyFilterRuleCollectionActionType
    extends ExpandableStringEnum<FirewallPolicyFilterRuleCollectionActionType> {
    /** Static value Allow for FirewallPolicyFilterRuleCollectionActionType. */
    public static final FirewallPolicyFilterRuleCollectionActionType ALLOW = fromString("Allow");

    /** Static value Deny for FirewallPolicyFilterRuleCollectionActionType. */
    public static final FirewallPolicyFilterRuleCollectionActionType DENY = fromString("Deny");

    /**
     * Creates or finds a FirewallPolicyFilterRuleCollectionActionType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FirewallPolicyFilterRuleCollectionActionType.
     */
    @JsonCreator
    public static FirewallPolicyFilterRuleCollectionActionType fromString(String name) {
        return fromString(name, FirewallPolicyFilterRuleCollectionActionType.class);
    }

    /**
     * Gets known FirewallPolicyFilterRuleCollectionActionType values.
     *
     * @return known FirewallPolicyFilterRuleCollectionActionType values.
     */
    public static Collection<FirewallPolicyFilterRuleCollectionActionType> values() {
        return values(FirewallPolicyFilterRuleCollectionActionType.class);
    }
}
