// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified. */
public final class WebApplicationFirewallState extends ExpandableStringEnum<WebApplicationFirewallState> {
    /** Static value Disabled for WebApplicationFirewallState. */
    public static final WebApplicationFirewallState DISABLED = fromString("Disabled");

    /** Static value Enabled for WebApplicationFirewallState. */
    public static final WebApplicationFirewallState ENABLED = fromString("Enabled");

    /**
     * Creates a new instance of WebApplicationFirewallState value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public WebApplicationFirewallState() {
    }

    /**
     * Creates or finds a WebApplicationFirewallState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WebApplicationFirewallState.
     */
    @JsonCreator
    public static WebApplicationFirewallState fromString(String name) {
        return fromString(name, WebApplicationFirewallState.class);
    }

    /**
     * Gets known WebApplicationFirewallState values.
     *
     * @return known WebApplicationFirewallState values.
     */
    public static Collection<WebApplicationFirewallState> values() {
        return values(WebApplicationFirewallState.class);
    }
}
