/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.MatchCondition;
import com.azure.resourcemanager.network.models.WebApplicationFirewallAction;
import com.azure.resourcemanager.network.models.WebApplicationFirewallRuleType;
import com.azure.resourcemanager.network.models.WebApplicationFirewallState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class WebApplicationFirewallCustomRule {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="priority", required=true)
    private int priority;
    @JsonProperty(value="state")
    private WebApplicationFirewallState state;
    @JsonProperty(value="ruleType", required=true)
    private WebApplicationFirewallRuleType ruleType;
    @JsonProperty(value="matchConditions", required=true)
    private List<MatchCondition> matchConditions;
    @JsonProperty(value="action", required=true)
    private WebApplicationFirewallAction action;
    private static final ClientLogger LOGGER = new ClientLogger(WebApplicationFirewallCustomRule.class);

    public String name() {
        return this.name;
    }

    public WebApplicationFirewallCustomRule withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public int priority() {
        return this.priority;
    }

    public WebApplicationFirewallCustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public WebApplicationFirewallState state() {
        return this.state;
    }

    public WebApplicationFirewallCustomRule withState(WebApplicationFirewallState state) {
        this.state = state;
        return this;
    }

    public WebApplicationFirewallRuleType ruleType() {
        return this.ruleType;
    }

    public WebApplicationFirewallCustomRule withRuleType(WebApplicationFirewallRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    public WebApplicationFirewallCustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public WebApplicationFirewallAction action() {
        return this.action;
    }

    public WebApplicationFirewallCustomRule withAction(WebApplicationFirewallAction action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.ruleType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ruleType in model WebApplicationFirewallCustomRule"));
        }
        if (this.matchConditions() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property matchConditions in model WebApplicationFirewallCustomRule"));
        }
        this.matchConditions().forEach(e -> e.validate());
        if (this.action() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property action in model WebApplicationFirewallCustomRule"));
        }
    }
}

