// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.SwapResourceInner;
import com.azure.resourcemanager.network.fluent.models.SwapResourceListResultInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in VipSwapsClient. */
public interface VipSwapsClient {
    /**
     * Gets the SwapResource which identifies the slot type for the specified cloud service. The slot type on a cloud
     * service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SwapResource which identifies the slot type for the specified cloud service along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SwapResourceInner>> getWithResponseAsync(String groupName, String resourceName);

    /**
     * Gets the SwapResource which identifies the slot type for the specified cloud service. The slot type on a cloud
     * service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SwapResource which identifies the slot type for the specified cloud service on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SwapResourceInner> getAsync(String groupName, String resourceName);

    /**
     * Gets the SwapResource which identifies the slot type for the specified cloud service. The slot type on a cloud
     * service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SwapResource which identifies the slot type for the specified cloud service along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SwapResourceInner> getWithResponse(String groupName, String resourceName, Context context);

    /**
     * Gets the SwapResource which identifies the slot type for the specified cloud service. The slot type on a cloud
     * service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SwapResource which identifies the slot type for the specified cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SwapResourceInner get(String groupName, String resourceName);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String groupName, String resourceName, SwapResourceInner parameters);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginCreateAsync(
        String groupName, String resourceName, SwapResourceInner parameters);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginCreate(String groupName, String resourceName, SwapResourceInner parameters);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginCreate(
        String groupName, String resourceName, SwapResourceInner parameters, Context context);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> createAsync(String groupName, String resourceName, SwapResourceInner parameters);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void create(String groupName, String resourceName, SwapResourceInner parameters);

    /**
     * Performs vip swap operation on swappable cloud services.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param parameters SwapResource object where slot type should be the target slot after vip swap for the specified
     *     cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void create(String groupName, String resourceName, SwapResourceInner parameters, Context context);

    /**
     * Gets the list of SwapResource which identifies the slot type for the specified cloud service. The slot type on a
     * cloud service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of SwapResource which identifies the slot type for the specified cloud service along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SwapResourceListResultInner>> listWithResponseAsync(String groupName, String resourceName);

    /**
     * Gets the list of SwapResource which identifies the slot type for the specified cloud service. The slot type on a
     * cloud service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of SwapResource which identifies the slot type for the specified cloud service on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SwapResourceListResultInner> listAsync(String groupName, String resourceName);

    /**
     * Gets the list of SwapResource which identifies the slot type for the specified cloud service. The slot type on a
     * cloud service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of SwapResource which identifies the slot type for the specified cloud service along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SwapResourceListResultInner> listWithResponse(String groupName, String resourceName, Context context);

    /**
     * Gets the list of SwapResource which identifies the slot type for the specified cloud service. The slot type on a
     * cloud service can either be Staging or Production.
     *
     * @param groupName The name of the resource group.
     * @param resourceName The name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of SwapResource which identifies the slot type for the specified cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SwapResourceListResultInner list(String groupName, String resourceName);
}
