// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A matching criteria which matches routes based on route prefix, community, and AS path. */
@Fluent
public final class Criterion {
    /*
     * List of route prefixes which this criteria matches.
     */
    @JsonProperty(value = "routePrefix")
    private List<String> routePrefix;

    /*
     * List of BGP communities which this criteria matches.
     */
    @JsonProperty(value = "community")
    private List<String> community;

    /*
     * List of AS paths which this criteria matches.
     */
    @JsonProperty(value = "asPath")
    private List<String> asPath;

    /*
     * Match condition to apply RouteMap rules.
     */
    @JsonProperty(value = "matchCondition")
    private RouteMapMatchCondition matchCondition;

    /** Creates an instance of Criterion class. */
    public Criterion() {
    }

    /**
     * Get the routePrefix property: List of route prefixes which this criteria matches.
     *
     * @return the routePrefix value.
     */
    public List<String> routePrefix() {
        return this.routePrefix;
    }

    /**
     * Set the routePrefix property: List of route prefixes which this criteria matches.
     *
     * @param routePrefix the routePrefix value to set.
     * @return the Criterion object itself.
     */
    public Criterion withRoutePrefix(List<String> routePrefix) {
        this.routePrefix = routePrefix;
        return this;
    }

    /**
     * Get the community property: List of BGP communities which this criteria matches.
     *
     * @return the community value.
     */
    public List<String> community() {
        return this.community;
    }

    /**
     * Set the community property: List of BGP communities which this criteria matches.
     *
     * @param community the community value to set.
     * @return the Criterion object itself.
     */
    public Criterion withCommunity(List<String> community) {
        this.community = community;
        return this;
    }

    /**
     * Get the asPath property: List of AS paths which this criteria matches.
     *
     * @return the asPath value.
     */
    public List<String> asPath() {
        return this.asPath;
    }

    /**
     * Set the asPath property: List of AS paths which this criteria matches.
     *
     * @param asPath the asPath value to set.
     * @return the Criterion object itself.
     */
    public Criterion withAsPath(List<String> asPath) {
        this.asPath = asPath;
        return this;
    }

    /**
     * Get the matchCondition property: Match condition to apply RouteMap rules.
     *
     * @return the matchCondition value.
     */
    public RouteMapMatchCondition matchCondition() {
        return this.matchCondition;
    }

    /**
     * Set the matchCondition property: Match condition to apply RouteMap rules.
     *
     * @param matchCondition the matchCondition value to set.
     * @return the Criterion object itself.
     */
    public Criterion withMatchCondition(RouteMapMatchCondition matchCondition) {
        this.matchCondition = matchCondition;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
