// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Gateway load balancer tunnel interface of a load balancer backend address pool. */
@Fluent
public final class GatewayLoadBalancerTunnelInterface {
    /*
     * Port of gateway load balancer tunnel interface.
     */
    @JsonProperty(value = "port")
    private Integer port;

    /*
     * Identifier of gateway load balancer tunnel interface.
     */
    @JsonProperty(value = "identifier")
    private Integer identifier;

    /*
     * Protocol of gateway load balancer tunnel interface.
     */
    @JsonProperty(value = "protocol")
    private GatewayLoadBalancerTunnelProtocol protocol;

    /*
     * Traffic type of gateway load balancer tunnel interface.
     */
    @JsonProperty(value = "type")
    private GatewayLoadBalancerTunnelInterfaceType type;

    /** Creates an instance of GatewayLoadBalancerTunnelInterface class. */
    public GatewayLoadBalancerTunnelInterface() {
    }

    /**
     * Get the port property: Port of gateway load balancer tunnel interface.
     *
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: Port of gateway load balancer tunnel interface.
     *
     * @param port the port value to set.
     * @return the GatewayLoadBalancerTunnelInterface object itself.
     */
    public GatewayLoadBalancerTunnelInterface withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the identifier property: Identifier of gateway load balancer tunnel interface.
     *
     * @return the identifier value.
     */
    public Integer identifier() {
        return this.identifier;
    }

    /**
     * Set the identifier property: Identifier of gateway load balancer tunnel interface.
     *
     * @param identifier the identifier value to set.
     * @return the GatewayLoadBalancerTunnelInterface object itself.
     */
    public GatewayLoadBalancerTunnelInterface withIdentifier(Integer identifier) {
        this.identifier = identifier;
        return this;
    }

    /**
     * Get the protocol property: Protocol of gateway load balancer tunnel interface.
     *
     * @return the protocol value.
     */
    public GatewayLoadBalancerTunnelProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Protocol of gateway load balancer tunnel interface.
     *
     * @param protocol the protocol value to set.
     * @return the GatewayLoadBalancerTunnelInterface object itself.
     */
    public GatewayLoadBalancerTunnelInterface withProtocol(GatewayLoadBalancerTunnelProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the type property: Traffic type of gateway load balancer tunnel interface.
     *
     * @return the type value.
     */
    public GatewayLoadBalancerTunnelInterfaceType type() {
        return this.type;
    }

    /**
     * Set the type property: Traffic type of gateway load balancer tunnel interface.
     *
     * @param type the type value to set.
     * @return the GatewayLoadBalancerTunnelInterface object itself.
     */
    public GatewayLoadBalancerTunnelInterface withType(GatewayLoadBalancerTunnelInterfaceType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
