/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ApplicationGatewayWafDynamicManifestsDefaultsClient;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayWafDynamicManifestResultInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import reactor.core.publisher.Mono;

public final class ApplicationGatewayWafDynamicManifestsDefaultsClientImpl
implements ApplicationGatewayWafDynamicManifestsDefaultsClient {
    private final ApplicationGatewayWafDynamicManifestsDefaultsService service;
    private final NetworkManagementClientImpl client;

    ApplicationGatewayWafDynamicManifestsDefaultsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ApplicationGatewayWafDynamicManifestsDefaultsService)RestProxy.create(ApplicationGatewayWafDynamicManifestsDefaultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApplicationGatewayWafDynamicManifestResultInner>> getWithResponseAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), location, "2022-09-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApplicationGatewayWafDynamicManifestResultInner>> getWithResponseAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), location, "2022-09-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApplicationGatewayWafDynamicManifestResultInner> getAsync(String location) {
        return this.getWithResponseAsync(location).flatMap(res -> Mono.justOrEmpty((Object)((ApplicationGatewayWafDynamicManifestResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApplicationGatewayWafDynamicManifestResultInner> getWithResponse(String location, Context context) {
        return (Response)this.getWithResponseAsync(location, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApplicationGatewayWafDynamicManifestResultInner get(String location) {
        return (ApplicationGatewayWafDynamicManifestResultInner)this.getWithResponse(location, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface ApplicationGatewayWafDynamicManifestsDefaultsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/applicationGatewayWafDynamicManifests/dafault")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationGatewayWafDynamicManifestResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

