/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.IpAddressAvailabilityResultInner;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.implementation.NetworkImpl;
import com.azure.resourcemanager.network.models.Delegation;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.azure.resourcemanager.network.models.RouteTable;
import com.azure.resourcemanager.network.models.ServiceEndpointPropertiesFormat;
import com.azure.resourcemanager.network.models.ServiceEndpointType;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateEndpointNetworkPolicies;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class SubnetImpl
extends ChildResourceImpl<SubnetInner, NetworkImpl, Network>
implements Subnet,
Subnet.Definition<Network.DefinitionStages.WithCreateAndSubnet>,
Subnet.UpdateDefinition<Network.Update>,
Subnet.Update {
    SubnetImpl(SubnetInner inner, NetworkImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public int networkInterfaceIPConfigurationCount() {
        List<IpConfigurationInner> ipConfigRefs = ((SubnetInner)((Object)this.innerModel())).ipConfigurations();
        if (ipConfigRefs != null) {
            return ipConfigRefs.size();
        }
        return 0;
    }

    @Override
    public String addressPrefix() {
        return ((SubnetInner)((Object)this.innerModel())).addressPrefix();
    }

    public String name() {
        return ((SubnetInner)((Object)this.innerModel())).name();
    }

    @Override
    public String networkSecurityGroupId() {
        return ((SubnetInner)((Object)this.innerModel())).networkSecurityGroup() != null ? ((SubnetInner)((Object)this.innerModel())).networkSecurityGroup().id() : null;
    }

    @Override
    public String routeTableId() {
        return ((SubnetInner)((Object)this.innerModel())).routeTable() != null ? ((SubnetInner)((Object)this.innerModel())).routeTable().id() : null;
    }

    @Override
    public Map<ServiceEndpointType, List<Region>> servicesWithAccess() {
        HashMap<ServiceEndpointType, List<Region>> services = new HashMap<ServiceEndpointType, List<Region>>();
        if (((SubnetInner)((Object)this.innerModel())).serviceEndpoints() != null) {
            for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)((Object)this.innerModel())).serviceEndpoints()) {
                ServiceEndpointType serviceEndpointType = ServiceEndpointType.fromString(endpoint.service());
                if (!services.containsKey((Object)serviceEndpointType)) {
                    services.put(serviceEndpointType, new ArrayList());
                }
                if (endpoint.locations() == null) continue;
                ArrayList<Region> regions = new ArrayList<Region>();
                for (String location : endpoint.locations()) {
                    regions.add(Region.fromName((String)location));
                }
                ((List)services.get((Object)serviceEndpointType)).addAll(regions);
            }
        }
        return services;
    }

    @Override
    public String id() {
        return ((SubnetInner)((Object)this.innerModel())).id();
    }

    @Override
    public SubnetImpl withoutNetworkSecurityGroup() {
        ((SubnetInner)((Object)this.innerModel())).withNetworkSecurityGroup(null);
        return this;
    }

    @Override
    public SubnetImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup nsg) {
        return this.withExistingNetworkSecurityGroup(nsg.id());
    }

    @Override
    public SubnetImpl withExistingNetworkSecurityGroup(String resourceId) {
        NetworkSecurityGroupInner reference = new NetworkSecurityGroupInner().withId(resourceId);
        ((SubnetInner)((Object)this.innerModel())).withNetworkSecurityGroup(reference);
        return this;
    }

    @Override
    public SubnetImpl withExistingRouteTable(String resourceId) {
        RouteTableInner reference = new RouteTableInner().withId(resourceId);
        ((SubnetInner)((Object)this.innerModel())).withRouteTable(reference);
        return this;
    }

    @Override
    public SubnetImpl withExistingRouteTable(RouteTable routeTable) {
        return this.withExistingRouteTable(routeTable.id());
    }

    @Override
    public Subnet.Update withoutRouteTable() {
        ((SubnetInner)((Object)this.innerModel())).withRouteTable(null);
        return this;
    }

    @Override
    public SubnetImpl withAddressPrefix(String cidr) {
        ((SubnetInner)((Object)this.innerModel())).withAddressPrefix(cidr);
        return this;
    }

    @Override
    public SubnetImpl withAccessFromService(ServiceEndpointType service) {
        if (((SubnetInner)((Object)this.innerModel())).serviceEndpoints() == null) {
            ((SubnetInner)((Object)this.innerModel())).withServiceEndpoints(new ArrayList<ServiceEndpointPropertiesFormat>());
        }
        boolean found = false;
        for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)((Object)this.innerModel())).serviceEndpoints()) {
            if (!endpoint.service().equalsIgnoreCase(service.toString())) continue;
            found = true;
            break;
        }
        if (!found) {
            ((SubnetInner)((Object)this.innerModel())).serviceEndpoints().add(new ServiceEndpointPropertiesFormat().withService(service.toString()).withLocations(new ArrayList<String>()));
        }
        return this;
    }

    @Override
    public Subnet.Update withoutAccessFromService(ServiceEndpointType service) {
        if (((SubnetInner)((Object)this.innerModel())).serviceEndpoints() != null) {
            int foundIndex = -1;
            int i = 0;
            for (ServiceEndpointPropertiesFormat endpoint : ((SubnetInner)((Object)this.innerModel())).serviceEndpoints()) {
                if (endpoint.service().equalsIgnoreCase(service.toString())) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((SubnetInner)((Object)this.innerModel())).serviceEndpoints().remove(foundIndex);
            }
        }
        return this;
    }

    public NetworkImpl attach() {
        return ((NetworkImpl)this.parent()).withSubnet(this);
    }

    @Override
    public RouteTable getRouteTable() {
        return this.routeTableId() != null ? (RouteTable)((NetworkManager)((NetworkImpl)this.parent()).manager()).routeTables().getById(this.routeTableId()) : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        String nsgId = this.networkSecurityGroupId();
        return nsgId != null ? (NetworkSecurityGroup)((NetworkManager)((NetworkImpl)this.parent()).manager()).networkSecurityGroups().getById(nsgId) : null;
    }

    @Override
    public Collection<NicIpConfiguration> listNetworkInterfaceIPConfigurations() {
        ArrayList<NicIpConfiguration> ipConfigs = new ArrayList<NicIpConfiguration>();
        TreeMap<String, NetworkInterface> nics = new TreeMap<String, NetworkInterface>();
        List<IpConfigurationInner> ipConfigRefs = ((SubnetInner)((Object)this.innerModel())).ipConfigurations();
        if (ipConfigRefs == null) {
            return ipConfigs;
        }
        for (IpConfigurationInner ipConfigRef : ipConfigRefs) {
            String nicID = ResourceUtils.parentResourceIdFromResourceId((String)ipConfigRef.id());
            String ipConfigName = ResourceUtils.nameFromResourceId((String)ipConfigRef.id());
            NetworkInterface nic = (NetworkInterface)nics.get(nicID.toLowerCase(Locale.ROOT));
            if (nic == null) {
                nic = (NetworkInterface)((NetworkManager)((NetworkImpl)this.parent()).manager()).networkInterfaces().getById(nicID);
            }
            if (nic == null) continue;
            nics.put(nic.id().toLowerCase(Locale.ROOT), nic);
            NicIpConfiguration ipConfig = nic.ipConfigurations().get(ipConfigName);
            if (ipConfig == null) continue;
            ipConfigs.add(ipConfig);
        }
        return Collections.unmodifiableCollection(ipConfigs);
    }

    @Override
    public Set<String> listAvailablePrivateIPAddresses() {
        TreeSet<String> ipAddresses = new TreeSet<String>();
        String cidr = this.addressPrefix();
        if (cidr == null) {
            return ipAddresses;
        }
        String takenIPAddress = cidr.split("/")[0];
        IpAddressAvailabilityResultInner result = ((NetworkManagementClient)((NetworkManager)((NetworkImpl)this.parent()).manager()).serviceClient()).getVirtualNetworks().checkIpAddressAvailability(((NetworkImpl)this.parent()).resourceGroupName(), ((NetworkImpl)this.parent()).name(), takenIPAddress);
        if (result == null || result.availableIpAddresses() == null) {
            return ipAddresses;
        }
        ipAddresses.addAll(result.availableIpAddresses());
        return ipAddresses;
    }

    @Override
    public SubnetImpl withDelegation(String serviceName) {
        if (((SubnetInner)((Object)this.innerModel())).delegations() == null) {
            ((SubnetInner)((Object)this.innerModel())).withDelegations(new ArrayList<Delegation>());
        }
        ((SubnetInner)((Object)this.innerModel())).delegations().add(new Delegation().withName(serviceName).withServiceName(serviceName));
        return this;
    }

    @Override
    public SubnetImpl withoutDelegation(String serviceName) {
        if (((SubnetInner)((Object)this.innerModel())).delegations() != null) {
            int i = 0;
            while (i < ((SubnetInner)((Object)this.innerModel())).delegations().size()) {
                if (serviceName.equalsIgnoreCase(((SubnetInner)((Object)this.innerModel())).delegations().get(i).serviceName())) {
                    ((SubnetInner)((Object)this.innerModel())).delegations().remove(i);
                    continue;
                }
                ++i;
            }
        }
        return this;
    }

    @Override
    public SubnetImpl enableNetworkPoliciesOnPrivateEndpoint() {
        ((SubnetInner)((Object)this.innerModel())).withPrivateEndpointNetworkPolicies(VirtualNetworkPrivateEndpointNetworkPolicies.ENABLED);
        return this;
    }

    @Override
    public SubnetImpl disableNetworkPoliciesOnPrivateEndpoint() {
        ((SubnetInner)((Object)this.innerModel())).withPrivateEndpointNetworkPolicies(VirtualNetworkPrivateEndpointNetworkPolicies.DISABLED);
        return this;
    }

    @Override
    public SubnetImpl enableNetworkPoliciesOnPrivateLinkService() {
        ((SubnetInner)((Object)this.innerModel())).withPrivateLinkServiceNetworkPolicies(VirtualNetworkPrivateLinkServiceNetworkPolicies.ENABLED);
        return this;
    }

    @Override
    public SubnetImpl disableNetworkPoliciesOnPrivateLinkService() {
        ((SubnetInner)((Object)this.innerModel())).withPrivateLinkServiceNetworkPolicies(VirtualNetworkPrivateLinkServiceNetworkPolicies.DISABLED);
        return this;
    }
}

