// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Will contain the filter name and values to operate on. */
@Fluent
public final class FilterItems {
    /*
     * The name of the field we would like to filter
     */
    @JsonProperty(value = "field")
    private String field;

    /*
     * List of values to filter the current field by
     */
    @JsonProperty(value = "values")
    private List<String> values;

    /** Creates an instance of FilterItems class. */
    public FilterItems() {
    }

    /**
     * Get the field property: The name of the field we would like to filter.
     *
     * @return the field value.
     */
    public String field() {
        return this.field;
    }

    /**
     * Set the field property: The name of the field we would like to filter.
     *
     * @param field the field value to set.
     * @return the FilterItems object itself.
     */
    public FilterItems withField(String field) {
        this.field = field;
        return this;
    }

    /**
     * Get the values property: List of values to filter the current field by.
     *
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: List of values to filter the current field by.
     *
     * @param values the values value to set.
     * @return the FilterItems object itself.
     */
    public FilterItems withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
